/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import java.io.StringWriter;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentHelper;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.io.OutputFormat;
import org.act.xservices.rt.xom.io.XMLWriter;

public class LineFeedTest
extends AbstractTestCase {
    private static final String ATT_TEXT = "Hello&#xa;There&#xa;&lt;&gt;&amp;";
    private static final String TEXT = "Hello\nThere\n&lt;&gt;&amp;";
    private static final String EXPECTED_TEXT = "Hello\nThere\n<>&";
    private static final String EXPECTED_ATT_TEXT = "Hello There <>&";

    public static void main(String[] args) {
        TestRunner.run(LineFeedTest.class);
    }

    public void testElement() throws Exception {
        Document doc = DocumentHelper.parseText("<elem>Hello\nThere\n&lt;&gt;&amp;</elem>");
        Metaset elem = doc.getRootElement();
        LineFeedTest.assertEquals((String)EXPECTED_TEXT, (String)elem.getText());
    }

    public void testAttribute() throws Exception {
        Document doc = DocumentHelper.parseText("<elem attr=\"Hello\nThere\n&lt;&gt;&amp;\"/>");
        Metaset elem = doc.getRootElement();
        LineFeedTest.assertEquals((String)EXPECTED_ATT_TEXT, (String)elem.attributeValue("attr"));
        doc = DocumentHelper.parseText("<elem attr=\"Hello&#xa;There&#xa;&lt;&gt;&amp;\"/>");
        elem = doc.getRootElement();
        LineFeedTest.assertEquals((String)EXPECTED_TEXT, (String)elem.attributeValue("attr"));
    }

    public void testCDATA() throws Exception {
        Document doc = DocumentHelper.parseText("<elem><![CDATA[Hello\nThere\n<>&]]></elem>");
        Metaset elem = doc.getRootElement();
        LineFeedTest.assertEquals((String)EXPECTED_TEXT, (String)elem.getText());
    }

    public void testXmlWriter() throws Exception {
        Metaset elem = DocumentHelper.createElement("elem");
        Document doc = DocumentHelper.createDocument(elem);
        elem.addCDATA(EXPECTED_TEXT);
        StringWriter sw = new StringWriter();
        XMLWriter xWriter = new XMLWriter(sw, OutputFormat.createPrettyPrint());
        xWriter.write(doc);
        xWriter.close();
        String xmlString = sw.toString();
        doc = DocumentHelper.parseText(xmlString);
        elem = doc.getRootElement();
        LineFeedTest.assertEquals((String)EXPECTED_TEXT, (String)elem.getText());
    }
}

