/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentHelper;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Node;

public class MakeElementTest
extends AbstractTestCase {
    public static void main(String[] args) {
        TestRunner.run(MakeElementTest.class);
    }

    public void testMakeElement() throws Exception {
        Document doc = DocumentHelper.createDocument();
        Metaset c = DocumentHelper.makeElement(doc, "a/b/c");
        MakeElementTest.assertTrue((String)"Should return a valid element", (c != null ? 1 : 0) != 0);
        Metaset c2 = DocumentHelper.makeElement(doc, "a/b/c");
        MakeElementTest.assertTrue((String)"Found same element again", (c == c2 ? 1 : 0) != 0);
        c.addAttribute("x", "123");
        Node found = doc.selectSingleNode("/a/b/c[@x='123']");
        MakeElementTest.assertEquals((String)"Found same node via XPath", (Object)c, (Object)found);
        Metaset b = c.getParent();
        Metaset e = DocumentHelper.makeElement(b, "c/d/e");
        MakeElementTest.assertTrue((String)"Should return a valid element", (e != null ? 1 : 0) != 0);
        Metaset e2 = DocumentHelper.makeElement(b, "c/d/e");
        MakeElementTest.assertTrue((String)"Found same element again", (e == e2 ? 1 : 0) != 0);
        e.addAttribute("y", "456");
        found = b.selectSingleNode("c/d/e[@y='456']");
        MakeElementTest.assertEquals((String)"Found same node via XPath", (Object)e, (Object)found);
    }

    public void testMakeQualifiedElement() throws Exception {
        Document doc = DocumentHelper.createDocument();
        Metaset root = doc.addElement("root");
        root.addNamespace("", "defaultURI");
        root.addNamespace("foo", "fooURI");
        root.addNamespace("bar", "barURI");
        Metaset c = DocumentHelper.makeElement(doc, "root/foo:b/bar:c");
        MakeElementTest.assertTrue((String)"Should return a valid element", (c != null ? 1 : 0) != 0);
        MakeElementTest.assertEquals((String)"c has a valid namespace", (String)"barURI", (String)c.getNamespaceURI());
        Metaset b = c.getParent();
        MakeElementTest.assertEquals((String)"b has a valid namespace", (String)"fooURI", (String)b.getNamespaceURI());
        this.log("Created: " + c);
        Metaset c2 = DocumentHelper.makeElement(doc, "root/foo:b/bar:c");
        MakeElementTest.assertTrue((String)"Found same element again", (c == c2 ? 1 : 0) != 0);
    }
}

