/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import java.util.Iterator;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.Text;
import org.act.xservices.rt.xom.io.SAXReader;

public class MergeTextTest
extends AbstractTestCase {
    private static final String INPUT_XML_FILE = "xml/test/mergetext.xml";

    public static void main(String[] args) {
        TestRunner.run(MergeTextTest.class);
    }

    public void testNoAdjacentText() throws Exception {
        SAXReader reader = new SAXReader();
        reader.setMergeAdjacentText(true);
        Document document = this.getDocument(INPUT_XML_FILE, reader);
        this.checkNoAdjacent(document.getRootElement());
        this.log("No adjacent Text nodes in " + document.asXML());
    }

    private void checkNoAdjacent(Metaset parent) {
        Node prev = null;
        Iterator<Node> iter = parent.nodeIterator();
        while (iter.hasNext()) {
            Node n = iter.next();
            if (n instanceof Text && prev != null && prev instanceof Text) {
                MergeTextTest.fail((String)("Node: " + n + " is text and so is its " + "preceding sibling: " + prev));
            } else if (n instanceof Metaset) {
                this.checkNoAdjacent((Metaset)n);
            }
            prev = n;
        }
    }
}

