/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentFactory;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Namespace;
import org.act.xservices.rt.xom.QName;
import org.act.xservices.rt.xom.io.SAXReader;

public class NamespaceTest
extends AbstractTestCase {
    private static final String INPUT_XML_FILE = "xml/namespaces.xml";
    private static final Namespace XSL_NAMESPACE = Namespace.get("xsl", "http://www.w3.org/1999/XSL/Transform");
    private static final QName XSL_TEMPLATE = QName.get("template", XSL_NAMESPACE);

    public static void main(String[] args) {
        TestRunner.run(NamespaceTest.class);
    }

    public void debugShowNamespaces() throws Exception {
        Metaset root = this.getRootElement();
        Iterator<Metaset> iter = root.elementIterator();
        while (iter.hasNext()) {
            Metaset element = iter.next();
            this.log("Found element:    " + element);
            this.log("Namespace:        " + element.getNamespace());
            this.log("Namespace prefix: " + element.getNamespacePrefix());
            this.log("Namespace URI:    " + element.getNamespaceURI());
        }
    }

    public void testGetElement() throws Exception {
        Metaset root = this.getRootElement();
        Metaset firstTemplate = root.element(XSL_TEMPLATE);
        NamespaceTest.assertTrue((String)"Root element contains at least one <xsl:template/> element", (firstTemplate != null ? 1 : 0) != 0);
        this.log("Found element: " + firstTemplate);
    }

    public void testGetElements() throws Exception {
        Metaset root = this.getRootElement();
        List<Metaset> list = root.elements(XSL_TEMPLATE);
        NamespaceTest.assertTrue((String)"Root element contains at least one <xsl:template/> element", (list.size() > 0 ? 1 : 0) != 0);
        this.log("Found elements: " + list);
    }

    public void testElementIterator() throws Exception {
        Metaset root = this.getRootElement();
        Iterator<Metaset> iter = root.elementIterator(XSL_TEMPLATE);
        NamespaceTest.assertTrue((String)"Root element contains at least one <xsl:template/> element", (boolean)iter.hasNext());
        do {
            Metaset element = iter.next();
            this.log("Found element: " + element);
        } while (iter.hasNext());
    }

    public void testNamespaceUriMap() throws Exception {
        HashMap<String, String> uris = new HashMap<String, String>();
        uris.put("x", "fooNamespace");
        uris.put("y", "barNamespace");
        DocumentFactory factory = new DocumentFactory();
        factory.setXPathNamespaceURIs(uris);
        SAXReader reader = new SAXReader();
        reader.setDocumentFactory(factory);
        Document doc = this.getDocument("xml/test/nestedNamespaces.xml", reader);
        String value = doc.valueOf("/x:pizza/y:cheese/x:pepper");
        this.log("Found value: " + value);
        NamespaceTest.assertEquals((String)"XPath used default namesapce URIS", (String)"works", (String)value);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.document = this.getDocument(INPUT_XML_FILE);
    }

    protected Metaset getRootElement() {
        Metaset root = this.document.getRootElement();
        NamespaceTest.assertTrue((String)"Document has root element", (root != null ? 1 : 0) != 0);
        return root;
    }
}

