/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Attribute;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentHelper;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Namespace;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.io.DOMReader;
import org.xml.sax.InputSource;

public class NamespacesTest
extends AbstractTestCase {
    public static void main(String[] args) {
        TestRunner.run(NamespacesTest.class);
    }

    public void testNamespaces() throws Exception {
        this.testNamespaces(this.document);
        this.testNamespaces(this.saxRoundTrip(this.document));
        this.testNamespaces(this.domRoundTrip(this.document));
    }

    public void testNamespaces(Document document) throws Exception {
        Document doc2 = (Document)document.clone();
        Metaset root = doc2.getRootElement();
        this.assertNamespace(root.getNamespace(), "", "http://www.w3.org/2001/XMLSchema");
        NamespacesTest.assertEquals((String)"xmlns=\"http://www.w3.org/2001/XMLSchema\"", (String)root.getNamespace().asXML());
        NamespacesTest.assertEquals((String)"namespace::*[name()='']", (String)root.getNamespace().getPath());
        NamespacesTest.assertEquals((String)"namespace::*[name()='']", (String)root.getNamespace().getUniquePath());
        List<Namespace> additionalNS = root.additionalNamespaces();
        NamespacesTest.assertTrue((String)"at least one additional namespace", (additionalNS != null && additionalNS.size() > 0 ? 1 : 0) != 0);
        Namespace ns = additionalNS.get(0);
        this.assertNamespace(ns, "t", "http://www.w3.org/namespace/");
        NamespacesTest.assertEquals((String)"xmlns:t=\"http://www.w3.org/namespace/\"", (String)ns.asXML());
        NamespacesTest.assertEquals((String)"namespace::t", (String)ns.getPath());
        NamespacesTest.assertEquals((String)"namespace::t", (String)ns.getUniquePath());
        Node node = root.node(0);
        NamespacesTest.assertTrue((String)"First node is a namespace", (boolean)(node instanceof Namespace));
        root.remove(ns);
        root.addNamespace("t", "myNewURI");
        additionalNS = root.additionalNamespaces();
        NamespacesTest.assertTrue((String)"at least one additional namespace", (additionalNS != null && additionalNS.size() > 0 ? 1 : 0) != 0);
        ns = additionalNS.get(0);
        this.assertNamespace(ns, "t", "myNewURI");
        additionalNS.remove(0);
        additionalNS.add(Namespace.get("t", "myNewURI-2"));
        additionalNS = root.additionalNamespaces();
        NamespacesTest.assertTrue((String)"at least one additional namespace", (additionalNS != null && additionalNS.size() > 0 ? 1 : 0) != 0);
        ns = additionalNS.get(0);
        this.assertNamespace(ns, "t", "myNewURI-2");
        additionalNS.clear();
        root.addNamespace("t", "myNewURI");
        additionalNS = root.additionalNamespaces();
        NamespacesTest.assertTrue((String)"at least one additional namespace", (additionalNS != null && additionalNS.size() > 0 ? 1 : 0) != 0);
        ns = additionalNS.get(0);
        this.assertNamespace(ns, "t", "myNewURI");
        this.log("Namespaces: " + additionalNS);
        this.log("XML is now");
        this.log(root.asXML());
    }

    public void testNamespaceForPrefix() throws Exception {
        this.testNamespaceForPrefix(this.document);
        this.testNamespaceForPrefix(this.saxRoundTrip(this.document));
        this.testNamespaceForPrefix(this.domRoundTrip(this.document));
    }

    public void testNamespaceForPrefix(Document document) throws Exception {
        Metaset root = document.getRootElement();
        Namespace ns = root.getNamespaceForPrefix("t");
        this.assertNamespace(ns, "t", "http://www.w3.org/namespace/");
        Metaset element = root.elements().get(0);
        Namespace ns2 = element.getNamespaceForPrefix("t");
        this.assertNamespace(ns2, "t", "http://www.w3.org/namespace/");
        NamespacesTest.assertTrue((String)"Same namespace instance returned", (ns == ns2 ? 1 : 0) != 0);
        this.log("found: " + ns.asXML());
    }

    public void testNamespaceForDefaultPrefix() throws Exception {
        Document document = this.getDocument("xml/test/defaultNamespace.xml");
        this.testNamespaceForDefaultPrefix(document);
        this.testNamespaceForDefaultPrefix(this.saxRoundTrip(document));
        this.testNamespaceForDefaultPrefix(this.domRoundTrip(document));
    }

    public void testNamespaceForDefaultPrefix(Document document) throws Exception {
        List<? extends Node> list = document.selectNodes("//*");
        for (Metaset metaset : list) {
            Namespace ns = metaset.getNamespaceForPrefix("");
            this.assertNamespace(ns, "", "dummyNamespace");
            ns = metaset.getNamespaceForPrefix(null);
            this.assertNamespace(ns, "", "dummyNamespace");
            this.log("found: " + ns.asXML());
        }
    }

    public void testAttributeDefaultPrefix() throws Exception {
        Document document = this.getDocument("xml/test/soap3.xml");
        this.testAttributeDefaultPrefix(document);
        this.testAttributeDefaultPrefix(this.saxRoundTrip(document));
        this.testAttributeDefaultPrefix(this.domRoundTrip(document));
    }

    public void testAttributeDefaultPrefix(Document document) throws Exception {
        List<? extends Node> list = document.selectNodes("//@*[local-name()='actor']");
        NamespacesTest.assertTrue((String)"Matched at least one 'actor' attribute", (list.size() > 0 ? 1 : 0) != 0);
        for (Attribute attribute : list) {
            this.log("found: " + attribute.asXML());
            Metaset element = attribute.getParent();
            NamespacesTest.assertTrue((String)"Attribute has a parent", (element != null ? 1 : 0) != 0);
            Namespace ns = element.getNamespaceForPrefix("");
            String uri = "http://schemas.xmlsoap.org/soap/envelope/";
            this.assertNamespace(ns, "", uri);
            Namespace ns2 = attribute.getNamespace();
            this.assertNamespace(ns2, "", "");
        }
    }

    public void testNamespaceForURI() throws Exception {
        this.testNamespaceForURI(this.document);
        this.testNamespaceForURI(this.saxRoundTrip(this.document));
        this.testNamespaceForURI(this.domRoundTrip(this.document));
    }

    public void testNamespaceForURI(Document document) throws Exception {
        Metaset root = document.getRootElement();
        Namespace ns = root.getNamespaceForURI("http://www.w3.org/namespace/");
        this.assertNamespace(ns, "t", "http://www.w3.org/namespace/");
        Metaset element = root.elements().get(0);
        Namespace ns2 = element.getNamespaceForURI("http://www.w3.org/namespace/");
        this.assertNamespace(ns2, "t", "http://www.w3.org/namespace/");
        NamespacesTest.assertTrue((String)"Same namespace instance returned", (ns == ns2 ? 1 : 0) != 0);
        this.log("found: " + ns.asXML());
    }

    public void testRedeclareNamespaces() throws Exception {
        Document document = this.getDocument("xml/test/soap2.xml");
        this.testRedeclareNamespaces(document);
        this.testRedeclareNamespaces(this.saxRoundTrip(document));
        this.testRedeclareNamespaces(this.domRoundTrip(document));
    }

    public void testRedeclareNamespaces(Document document) throws Exception {
        String uri = "http://schemas.xmlsoap.org/soap/envelope/";
        this.assertNamespaces(document.selectNodes("//*[local-name()='Envelope']"), "SOAP-ENV", uri);
        this.assertNamespaces(document.selectNodes("//*[local-name()='Body']"), "SOAP-ENV", uri);
        this.assertNamespaces(document.selectNodes("//*[local-name()='bar']"), "a", "barURI");
        this.assertNamespaces(document.selectNodes("//*[local-name()='newBar']"), "a", "newBarURI");
        this.assertNamespaces(document.selectNodes("//*[local-name()='foo']"), "", "fooURI");
        this.assertNamespaces(document.selectNodes("//*[local-name()='newFoo']"), "", "newFooURI");
    }

    public void testDefaultNamespaceIssue() throws Exception {
        Document document = this.getDocument("xml/test/defaultNamespaceIssue.xsd");
        this.testDefaultNamespaceIssue(document);
        this.testDefaultNamespaceIssue(this.saxRoundTrip(document));
        this.testDefaultNamespaceIssue(this.domRoundTrip(document));
    }

    public void testDefaultNamespaceIssue(Document document) throws Exception {
        String expr = "/xsd:schema/xsd:element/xsd:annotation/xsd:documentation/text";
        NamespacesTest.assertNotNull((String)"default namespace redeclaration", (Object)((Metaset)document.selectSingleNode(expr)));
        for (Namespace ns : document.getRootElement().declaredNamespaces()) {
            if (!"urn:wapforum:devicesheet".equals(ns.getURI()) || !"".equals(ns.getPrefix())) continue;
            return;
        }
        NamespacesTest.fail((String)"Default namespace declaration not present on root element");
    }

    public void testDefaultNamespace() throws Exception {
        Document doc = DocumentHelper.createDocument();
        Metaset processDef = doc.addElement("process-definition", "http://jbpm.org/statedefinition-2.0-beta3");
        Metaset startState = processDef.addElement("start-state");
        startState.addAttribute("name", "start");
        Metaset transition = startState.addElement("transition");
        transition.addAttribute("to", "first");
        NamespacesTest.assertEquals((String)"http://jbpm.org/statedefinition-2.0-beta3", (String)startState.getNamespace().getURI());
        NamespacesTest.assertEquals((String)"", (String)startState.getNamespace().getPrefix());
        System.out.println(doc.asXML());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.document = this.getDocument("xml/test/test_schema.xml");
    }

    protected Document saxRoundTrip(Document document) throws Exception {
        return DocumentHelper.parseText(document.asXML());
    }

    protected Document domRoundTrip(Document document) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        org.w3c.dom.Document domDocument = builder.parse(new InputSource(new StringReader(document.asXML())));
        DOMReader domReader = new DOMReader();
        return domReader.read(domDocument);
    }

    protected void assertNamespaces(List elements, String prefix, String uri) throws Exception {
        for (Metaset element : elements) {
            this.assertNamespace(element.getNamespace(), prefix, uri);
        }
    }

    protected void assertNamespace(Namespace ns, String prefix, String uri) throws Exception {
        NamespacesTest.assertEquals((String)"namespace prefix", (String)prefix, (String)ns.getPrefix());
        NamespacesTest.assertEquals((String)"namespace URI", (String)uri, (String)ns.getURI());
    }
}

