/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import java.util.EnumSet;
import org.act.xservices.rt.xom.Attribute;
import org.act.xservices.rt.xom.Branch;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Namespace;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.NodeType;
import org.act.xservices.rt.xom.ProcessingInstruction;
import org.act.xservices.rt.xom.QName;
import org.act.xservices.rt.xom.tree.BackedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NodeHelper {
    private static final EnumSet<NodeType> BRANCH_TYPE = EnumSet.of(NodeType.ELEMENT_NODE, NodeType.DOCUMENT_NODE);

    private NodeHelper() {
    }

    public static Attribute nodeAsAttribute(Node node) {
        if (node.getNodeTypeEnum() == NodeType.ATTRIBUTE_NODE) {
            assert (node instanceof Attribute);
            return (Attribute)node;
        }
        return null;
    }

    public static Branch nodeAsBranch(Node node) {
        if (BRANCH_TYPE.contains(node.getNodeType())) {
            assert (node instanceof Branch);
            return (Branch)node;
        }
        return null;
    }

    public static Document nodeAsDocument(Node node) {
        if (node.getNodeTypeEnum() == NodeType.DOCUMENT_NODE) {
            assert (node instanceof Document);
            return (Document)node;
        }
        return null;
    }

    public static Metaset nodeAsElement(Node node) {
        if (node.getNodeTypeEnum() == NodeType.ELEMENT_NODE) {
            assert (node instanceof Metaset);
            return (Metaset)node;
        }
        return null;
    }

    public static Namespace nodeAsNamespace(Node node) {
        if (node.getNodeTypeEnum() == NodeType.NAMESPACE_NODE) {
            assert (node instanceof Namespace);
            return (Namespace)node;
        }
        return null;
    }

    public static ProcessingInstruction nodeAsProcessingInstruction(Node node) {
        if (node.getNodeTypeEnum() == NodeType.PROCESSING_INSTRUCTION_NODE) {
            assert (node instanceof ProcessingInstruction);
            return (ProcessingInstruction)node;
        }
        return null;
    }

    public static BackedList<Metaset> appendElementLocal(Node node, BackedList<Metaset> list) {
        Metaset element = NodeHelper.nodeAsElement(node);
        if (element != null) {
            list.addLocal(element);
        }
        return list;
    }

    public static BackedList<Metaset> appendElementNamedLocal(Node node, BackedList<Metaset> list, String name) {
        Metaset element = NodeHelper.nodeAsElement(node);
        if (element != null && name.equals(element.getName())) {
            list.addLocal(element);
        }
        return list;
    }

    public static BackedList<Metaset> appendElementQNamedLocal(Node node, BackedList<Metaset> list, QName qname) {
        Metaset element = NodeHelper.nodeAsElement(node);
        if (element != null && qname.equals(element.getQName())) {
            list.addLocal(element);
        }
        return list;
    }

    public static String getAttributeValue(Attribute attribute, String defaultValue) {
        return attribute == null ? defaultValue : attribute.getValue();
    }
}

