/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import java.util.Iterator;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Attribute;
import org.act.xservices.rt.xom.CDATA;
import org.act.xservices.rt.xom.Comment;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentType;
import org.act.xservices.rt.xom.Entity;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Namespace;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.ProcessingInstruction;
import org.act.xservices.rt.xom.Text;

public class NodeTypeNameTest
extends AbstractTestCase {
    public static void main(String[] args) {
        TestRunner.run(NodeTypeNameTest.class);
    }

    public void testDocument() throws Exception {
        this.testDocument(this.getDocument());
    }

    public void testCDATA() throws Exception {
        this.testDocument("xml/cdata.xml");
    }

    public void testNamespaces() throws Exception {
        this.testDocument("xml/namespaces.xml");
        this.testDocument("xml/testNamespaces.xml");
    }

    public void testPI() throws Exception {
        this.testDocument("xml/testPI.xml");
    }

    public void testInline() throws Exception {
        this.testDocument("xml/inline.xml");
    }

    protected void testDocument(String fileName) throws Exception {
        Document document = this.getDocument(fileName);
        this.testDocument(document);
    }

    protected void testDocument(Document document) throws Exception {
        NodeTypeNameTest.assertEquals((String)document.getNodeTypeName(), (String)"Document");
        DocumentType docType = document.getDocType();
        if (docType != null) {
            NodeTypeNameTest.assertEquals((String)docType.getNodeTypeName(), (String)"DocumentType");
        }
        this.testElement(document.getRootElement());
    }

    protected void testElement(Metaset element) {
        NodeTypeNameTest.assertEquals((String)element.getNodeTypeName(), (String)"Element");
        Iterator<Node> iter = element.attributeIterator();
        while (iter.hasNext()) {
            Attribute attribute = iter.next();
            NodeTypeNameTest.assertEquals((String)attribute.getNodeTypeName(), (String)"Attribute");
        }
        iter = element.nodeIterator();
        while (iter.hasNext()) {
            Node node = iter.next();
            String nodeTypeName = node.getNodeTypeName();
            if (node instanceof Attribute) {
                NodeTypeNameTest.assertEquals((String)nodeTypeName, (String)"Attribute");
                continue;
            }
            if (node instanceof CDATA) {
                NodeTypeNameTest.assertEquals((String)nodeTypeName, (String)"CDATA");
                continue;
            }
            if (node instanceof Comment) {
                NodeTypeNameTest.assertEquals((String)nodeTypeName, (String)"Comment");
                continue;
            }
            if (node instanceof Metaset) {
                NodeTypeNameTest.assertEquals((String)nodeTypeName, (String)"Element");
                this.testElement((Metaset)node);
                continue;
            }
            if (node instanceof Entity) {
                NodeTypeNameTest.assertEquals((String)nodeTypeName, (String)"Entity");
                continue;
            }
            if (node instanceof Metaset) {
                NodeTypeNameTest.assertEquals((String)nodeTypeName, (String)"Element");
                continue;
            }
            if (node instanceof Namespace) {
                NodeTypeNameTest.assertEquals((String)nodeTypeName, (String)"Namespace");
                continue;
            }
            if (node instanceof ProcessingInstruction) {
                NodeTypeNameTest.assertEquals((String)nodeTypeName, (String)"ProcessingInstruction");
                continue;
            }
            if (node instanceof Text) {
                NodeTypeNameTest.assertEquals((String)nodeTypeName, (String)"Text");
                continue;
            }
            NodeTypeNameTest.assertTrue((String)("Invalid node type: " + nodeTypeName + " for node: " + node), (boolean)false);
        }
    }
}

