/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import java.util.List;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.DocumentFactory;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Node;

public class ParentTest
extends AbstractTestCase {
    public static void main(String[] args) {
        TestRunner.run(ParentTest.class);
    }

    public void testDocument() throws Exception {
        this.testParentRelationship(this.document.getRootElement());
    }

    public void testFragment() throws Exception {
        DocumentFactory factory = new DocumentFactory();
        Metaset root = factory.createElement("root");
        Metaset first = root.addElement("child");
        Metaset second = root.addElement("child");
        this.testXPathNode(root, first);
        this.testXPathNode(root, second);
    }

    protected void testParentRelationship(Metaset parent, List content) {
        for (Object object : content) {
            if (object instanceof Metaset) {
                this.testParentRelationship((Metaset)object);
            }
            this.testXPathNode(parent, (Node)object);
        }
    }

    protected void testParentRelationship(Metaset element) {
        this.testParentRelationship(element, element.attributes());
        this.testParentRelationship(element, element.content());
    }

    protected void testXPathNode(Metaset parent, Node node) {
        if (node.supportsParent()) {
            this.log("Node: " + node);
            this.log("Parent: " + parent);
            this.log("getParent(): " + node.getParent());
            ParentTest.assertTrue((String)("getParent() returns parent for: " + node), (node.getParent() == parent ? 1 : 0) != 0);
        } else {
            Node xpathNode = node.asXPathResult(parent);
            ParentTest.assertTrue((String)("XPath Node supports parent for: " + xpathNode), (boolean)xpathNode.supportsParent());
            ParentTest.assertTrue((String)("getParent() returns parent for: " + xpathNode), (xpathNode.getParent() == parent ? 1 : 0) != 0);
        }
    }
}

