/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.NodeType;
import org.act.xservices.rt.xom.io.SAXContentHandler;
import org.xml.sax.XMLReader;

public class SAXContentHandlerTest
extends AbstractTestCase {
    private XMLReader xmlReader;
    protected String[] testDocuments = new String[]{"xml/test/test_schema.xml", "xml/test/encode.xml", "xml/fibo.xml", "xml/test/schema/personal-prefix.xsd", "xml/test/soap2.xml"};

    public static void main(String[] args) {
        TestRunner.run(SAXContentHandlerTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser parser = spf.newSAXParser();
        this.xmlReader = parser.getXMLReader();
    }

    public void testSAXContentHandler() throws Exception {
        SAXContentHandler contentHandler = new SAXContentHandler();
        this.xmlReader.setContentHandler(contentHandler);
        this.xmlReader.setDTDHandler(contentHandler);
        this.xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", contentHandler);
        int i = 0;
        int size = this.testDocuments.length;
        while (i < size) {
            Document docFromSAXReader = this.getDocument(this.testDocuments[i]);
            this.xmlReader.parse(this.getFile(this.testDocuments[i]).toString());
            Document docFromSAXContentHandler = contentHandler.getDocument();
            docFromSAXContentHandler.setName(docFromSAXReader.getName());
            this.assertDocumentsEqual(docFromSAXReader, docFromSAXContentHandler);
            SAXContentHandlerTest.assertEquals((String)docFromSAXReader.asXML(), (String)docFromSAXContentHandler.asXML());
            ++i;
        }
    }

    public void testBug926713() throws Exception {
        Document doc = this.getDocument("xml/test/cdata.xml");
        Metaset foo = doc.getRootElement();
        Metaset bar = foo.element("bar");
        List<Node> content = bar.content();
        SAXContentHandlerTest.assertEquals((int)3, (int)content.size());
        SAXContentHandlerTest.assertEquals((short)NodeType.TEXT_NODE.getCode(), (short)content.get(0).getNodeType());
        SAXContentHandlerTest.assertEquals((short)NodeType.CDATA_SECTION_NODE.getCode(), (short)content.get(1).getNodeType());
        SAXContentHandlerTest.assertEquals((short)NodeType.TEXT_NODE.getCode(), (short)content.get(2).getNodeType());
    }
}

