/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentFactory;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.XPath;
import org.act.xservices.rt.xom.io.SAXReader;

public class SerializeTest
extends AbstractTestCase {
    public static void main(String[] args) {
        TestRunner.run(SerializeTest.class);
    }

    public void testSerializePeriodicTable() throws Exception {
        this.testSerialize("xml/periodic_table.xml");
    }

    public void testSerializeMuchAdo() throws Exception {
        this.testSerialize("xml/much_ado.xml");
    }

    public void testSerializeTestSchema() throws Exception {
        this.testSerialize("xml/test/schema/personal.xsd");
    }

    public void testSerializeXPath() throws Exception {
        HashMap<String, String> uris = new HashMap<String, String>();
        uris.put("SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
        uris.put("m", "urn:xmethodsBabelFish");
        DocumentFactory factory = new DocumentFactory();
        factory.setXPathNamespaceURIs(uris);
        SAXReader reader = new SAXReader();
        reader.setDocumentFactory(factory);
        Document doc = this.getDocument("xml/soap.xml", reader);
        String expr = "/SOAP-ENV:Envelope/SOAP-ENV:Body/m:BabelFish";
        Node element = doc.selectSingleNode(expr);
        SerializeTest.assertTrue((String)"Found valid element", (element != null ? 1 : 0) != 0);
        XPath xpath = factory.createXPath("/SOAP-ENV:Envelope/SOAP-ENV:Body/m:BabelFish");
        element = xpath.selectSingleNode(doc);
        SerializeTest.assertTrue((String)"Found valid element", (element != null ? 1 : 0) != 0);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytesOut);
        out.writeObject(xpath);
        out.close();
        byte[] data = bytesOut.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
        XPath xpath2 = (XPath)in.readObject();
        in.close();
        element = xpath2.selectSingleNode(doc);
        SerializeTest.assertTrue((String)"Found valid element", (element != null ? 1 : 0) != 0);
    }

    protected void testSerialize(String xmlFile) throws Exception {
        Document document = this.getDocument(xmlFile);
        String text = document.asXML();
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytesOut);
        out.writeObject(document);
        out.close();
        byte[] data = bytesOut.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
        Document doc2 = (Document)in.readObject();
        in.close();
        String text2 = doc2.asXML();
        SerializeTest.assertEquals((String)"Documents text are equal", (String)text, (String)text2);
        SerializeTest.assertTrue((String)"Read back document after serialization", (doc2 != null && doc2 instanceof Document ? 1 : 0) != 0);
        this.assertDocumentsEqual(document, doc2);
        doc2.getRootElement().addElement("new");
    }
}

