/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Branch;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentHelper;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Node;

public class SetContentTest
extends AbstractTestCase {
    public static void main(String[] args) {
        TestRunner.run(SetContentTest.class);
    }

    public void testDocument() throws Exception {
        this.document.setName("doc1");
        Metaset oldRoot = this.document.getRootElement();
        SetContentTest.assertTrue((String)"Current root has document", (oldRoot.getDocument() == this.document ? 1 : 0) != 0);
        Document doc2 = DocumentHelper.createDocument();
        doc2.setName("doc2");
        SetContentTest.assertTrue((String)"Doc2 has no root element", (doc2.getRootElement() == null ? 1 : 0) != 0);
        doc2.setContent(this.document.content());
        Metaset newRoot = doc2.getRootElement();
        SetContentTest.assertTrue((String)"Current root has document", (oldRoot.getDocument() == this.document ? 1 : 0) != 0);
        SetContentTest.assertTrue((String)"Doc2 has now has root element", (newRoot != null ? 1 : 0) != 0);
        SetContentTest.assertTrue((String)"Doc2 has different root element", (newRoot != oldRoot ? 1 : 0) != 0);
        SetContentTest.assertTrue((String)"Root element now has document", (newRoot.getDocument() == doc2 ? 1 : 0) != 0);
        this.testParent(doc2.getRootElement());
        this.testDocument(doc2, doc2);
        doc2.clearContent();
        SetContentTest.assertTrue((String)"New Doc has no root", (doc2.getRootElement() == null ? 1 : 0) != 0);
        SetContentTest.assertTrue((String)"New root has no document", (newRoot.getDocument() == null ? 1 : 0) != 0);
    }

    public void testRootElement() throws Exception {
        Document doc3 = DocumentHelper.createDocument();
        doc3.setName("doc3");
        Metaset root = doc3.addElement("root");
        Metaset oldElement = root.addElement("old");
        SetContentTest.assertTrue((String)"Doc3 has root element", (root != null ? 1 : 0) != 0);
        root.setContent(this.document.getRootElement().content());
        SetContentTest.assertTrue((String)"Doc3's root now has content", (root.nodeCount() > 0 ? 1 : 0) != 0);
        SetContentTest.assertTrue((String)"Old element has no parent now", (oldElement.getParent() == null ? 1 : 0) != 0);
        SetContentTest.assertTrue((String)"Old element has no document now", (oldElement.getDocument() == null ? 1 : 0) != 0);
        this.testParent(root);
        this.testDocument(root, doc3);
    }

    protected void testParent(Branch parent) {
        int i = 0;
        int size = parent.nodeCount();
        while (i < size) {
            Node node = parent.node(i);
            SetContentTest.assertTrue((String)"Child node of root has parent of root", (node.getParent() == parent ? 1 : 0) != 0);
            ++i;
        }
    }

    protected void testDocument(Branch branch, Document doc) {
        int i = 0;
        int size = branch.nodeCount();
        while (i < size) {
            Node node = branch.node(i);
            SetContentTest.assertTrue((String)"Node has correct document", (node.getDocument() == doc ? 1 : 0) != 0);
            ++i;
        }
    }
}

