/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Attribute;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentFactory;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.io.SAXReader;
import org.act.xservices.rt.xom.util.UserDataAttribute;
import org.act.xservices.rt.xom.util.UserDataDocumentFactory;
import org.act.xservices.rt.xom.util.UserDataElement;

public class UserDataTest
extends AbstractTestCase {
    private static final String INPUT_XML_FILE = "xml/web.xml";
    private Object userData = new Double(1.23456);

    public static void main(String[] args) {
        TestRunner.run(UserDataTest.class);
    }

    public void testSetData() throws Exception {
        Metaset root = this.getRootElement();
        UserDataTest.assertTrue((String)"Element instanceof UserDataElement", (boolean)(root instanceof UserDataElement));
        root.setData(this.userData);
        UserDataTest.assertTrue((String)"Stored user data!", (root.getData() == this.userData ? 1 : 0) != 0);
        this.log("root: " + root);
        this.assertUserData(root, this.userData);
        Metaset cloned = (Metaset)root.clone();
        UserDataTest.assertTrue((String)"Cloned new instance", (cloned != root ? 1 : 0) != 0);
        this.assertUserData(cloned, this.userData);
        cloned = root.createCopy();
        UserDataTest.assertTrue((String)"Cloned new instance", (cloned != root ? 1 : 0) != 0);
        this.assertUserData(cloned, this.userData);
    }

    public void testCloneAttribute() throws Exception {
        Metaset root = this.getRootElement();
        root.addAttribute("name", "value");
        Attribute attribute = root.attribute("name");
        UserDataTest.assertTrue((boolean)(attribute instanceof UserDataAttribute));
        Metaset cloned = (Metaset)root.clone();
        Attribute clonedAttribute = cloned.attribute("name");
        UserDataTest.assertTrue((boolean)(clonedAttribute instanceof UserDataAttribute));
    }

    public void testNewAdditions() throws Exception {
        Metaset root = this.getRootElement();
        Metaset newElement = root.addElement("foo1234");
        UserDataTest.assertTrue((String)"New Element is a UserDataElement", (boolean)(newElement instanceof UserDataElement));
        root.addAttribute("bar456", "123");
        Attribute newAttribute = root.attribute("bar456");
        UserDataTest.assertTrue((String)"New Attribute is a UserDataAttribute", (boolean)(newAttribute instanceof UserDataAttribute));
    }

    public void testNewDocument() throws Exception {
        DocumentFactory factory = UserDataDocumentFactory.getInstance();
        Document document = factory.createDocument();
        Metaset root = document.addElement("root");
        UserDataTest.assertTrue((String)"Root Element is a UserDataElement", (boolean)(root instanceof UserDataElement));
        Metaset newElement = root.addElement("foo1234");
        UserDataTest.assertTrue((String)"New Element is a UserDataElement", (boolean)(newElement instanceof UserDataElement));
        root.addAttribute("bar456", "123");
        Attribute newAttribute = root.attribute("bar456");
        UserDataTest.assertTrue((String)"New Attribute is a UserDataAttribute", (boolean)(newAttribute instanceof UserDataAttribute));
    }

    protected void assertUserData(Metaset root, Object data) throws Exception {
        Object result = root.getData();
        UserDataTest.assertTrue((String)"No user data!", (result != null ? 1 : 0) != 0);
        UserDataTest.assertTrue((String)"Stored user data correctly", (boolean)data.equals(result));
    }

    protected void setUp() throws Exception {
        super.setUp();
        SAXReader reader = new SAXReader();
        reader.setDocumentFactory(UserDataDocumentFactory.getInstance());
        this.document = this.getDocument(INPUT_XML_FILE, reader);
    }
}

