/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import java.util.List;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentFactory;
import org.act.xservices.rt.xom.DocumentHelper;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Namespace;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.XPath;

public class XPathBugTest
extends AbstractTestCase {
    public static void main(String[] args) {
        TestRunner.run(XPathBugTest.class);
    }

    public void testXPaths() throws Exception {
        Document document = this.getDocument("xml/rabo1ae.xml");
        Metaset root = (Metaset)document.selectSingleNode("/m:Msg/m:Contents/m:Content");
        XPathBugTest.assertTrue((String)"root is not null", (root != null ? 1 : 0) != 0);
        Namespace ns = root.getNamespaceForPrefix("ab");
        XPathBugTest.assertTrue((String)"Found namespace", (ns != null ? 1 : 0) != 0);
        System.out.println("Found: " + ns.getURI());
        Metaset element = (Metaset)root.selectSingleNode("ab:RaboPayLoad[@id='1234123']");
        XPathBugTest.assertTrue((String)"element is not null", (element != null ? 1 : 0) != 0);
        String value = element.valueOf("ab:AccountingEntry/ab:RateType");
        XPathBugTest.assertEquals((String)"RateType is correct", (String)"CRRNT", (String)value);
    }

    public void testRobLebowitz() throws Exception {
        String text = "<ul>    <ul>        <li/>            <ul>                <li/>            </ul>        <li/>    </ul></ul>";
        Document document = DocumentHelper.parseText(text);
        List<? extends Node> lists = document.selectNodes("//ul | //ol");
        boolean count = false;
        int i = 0;
        while (i < lists.size()) {
            Metaset list = (Metaset)lists.get(i);
            List<? extends Node> nodes = list.selectNodes("ancestor::ul");
            if (nodes != null && nodes.size() > 0 || (nodes = list.selectNodes("ancestor::ol")) == null || nodes.size() > 0) {
                // empty if block
            }
            ++i;
        }
    }

    public void testStefan() throws Exception {
        String text = "<foo>hello</foo>";
        Document document = DocumentHelper.parseText(text);
        XPath xpath = DocumentHelper.createXPath("/x");
        Object value = xpath.evaluate(document);
    }

    public void testMikeSkells() throws Exception {
        Document top = DocumentFactory.getInstance().createDocument();
        Metaset root = top.addElement("root");
        root.addElement("child1").addElement("child11");
        root.addElement("child2").addElement("child21");
        System.out.println(top.asXML());
        XPath test1 = top.createXPath("/root/child1/child11");
        XPath test2 = top.createXPath("/root/child2/child21");
        Node position1 = test1.selectSingleNode(root);
        Node position2 = test2.selectSingleNode(root);
        System.out.println("test1= " + test1);
        System.out.println("test2= " + test2);
        System.out.println("Position1 Xpath = " + position1.getUniquePath());
        System.out.println("Position2 Xpath = " + position2.getUniquePath());
        System.out.println("test2.matches(position1) : " + test2.matches(position1));
        XPathBugTest.assertTrue((String)"test1.matches(position1)", (boolean)test1.matches(position1));
        XPathBugTest.assertTrue((String)"test2.matches(position2)", (boolean)test2.matches(position2));
        XPathBugTest.assertTrue((String)"test2.matches(position1) should be false", (!test2.matches(position1) ? 1 : 0) != 0);
    }
}

