/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentFactory;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.XPathException;
import org.act.xservices.rt.xom.io.SAXReader;
import org.act.xservices.rt.xom.rule.Pattern;

public class XPathExamplesTest
extends AbstractTestCase {
    protected SAXReader xmlReader = new SAXReader();
    protected Document testDocument;
    protected Node testContext;
    protected DocumentFactory factory = DocumentFactory.getInstance();

    public static void main(String[] args) {
        TestRunner.run(XPathExamplesTest.class);
    }

    public void testXPaths() throws Exception {
        Document document = this.getDocument("xml/test/xpath/tests.xml");
        Metaset root = document.getRootElement();
        Iterator<Metaset> iter = root.elementIterator("document");
        while (iter.hasNext()) {
            Metaset documentTest = iter.next();
            this.testDocument(documentTest);
        }
    }

    protected void testDocument(Metaset documentTest) throws Exception {
        String url = documentTest.attributeValue("url");
        this.testDocument = this.xmlReader.read(this.getFile(url));
        XPathExamplesTest.assertTrue((String)("Loaded test document: " + url), (this.testDocument != null ? 1 : 0) != 0);
        this.log("Loaded document: " + url);
        Iterator<Metaset> iter = documentTest.elementIterator("context");
        while (iter.hasNext()) {
            Metaset context = iter.next();
            this.testContext(documentTest, context);
        }
    }

    protected void testContext(Metaset documentTest, Metaset context) throws Exception {
        String xpath = context.attributeValue("select");
        List<? extends Node> list = this.testDocument.selectNodes(xpath);
        XPathExamplesTest.assertTrue((String)("Found at least one context nodes to test for path: " + xpath), (list != null && list.size() > 0 ? 1 : 0) != 0);
        for (Node node : list) {
            XPathExamplesTest.assertTrue((String)("Context node is a Node: " + node), (boolean)(node instanceof Node));
            this.testContext = node;
            this.log("Context is now: " + this.testContext);
            this.runTests(documentTest, context);
            this.log("");
        }
    }

    protected void runTests(Metaset documentTest, Metaset context) throws Exception {
        Iterator<Metaset> iter = context.elementIterator("test");
        while (iter.hasNext()) {
            Metaset test = iter.next();
            this.runTest(documentTest, context, test);
        }
        Iterator<Metaset> it = context.elementIterator("valueOf");
        while (it.hasNext()) {
            Metaset valueOf = it.next();
            this.testValueOf(documentTest, context, valueOf);
        }
        it = context.elementIterator("pattern");
        while (it.hasNext()) {
            Metaset pattern = it.next();
            this.testPattern(documentTest, context, pattern);
        }
        it = context.elementIterator("fileter");
        while (it.hasNext()) {
            Metaset filter = it.next();
            this.testFilter(documentTest, context, filter);
        }
    }

    protected void runTest(Metaset documentTest, Metaset context, Metaset test) throws Exception {
        Metaset valueOf;
        String count;
        String xpath = test.attributeValue("select");
        String description = "Path: " + xpath;
        String exception = test.attributeValue("exception");
        if (exception != null && exception.equals("true")) {
            try {
                this.testContext.selectNodes(xpath);
                XPathExamplesTest.fail((String)"Exception was not thrown");
            }
            catch (XPathException e) {
                return;
            }
        }
        if ((count = test.attributeValue("count")) != null) {
            int expectedSize = Integer.parseInt(count);
            List<? extends Node> results = this.testContext.selectNodes(xpath);
            this.log(String.valueOf(description) + " found result size: " + results.size());
            XPathExamplesTest.assertEquals((String)(String.valueOf(description) + " wrong result size"), (int)expectedSize, (int)results.size());
        }
        if ((valueOf = test.element("valueOf")) != null) {
            Node node = this.testContext.selectSingleNode(xpath);
            XPathExamplesTest.assertTrue((String)(String.valueOf(description) + " found node"), (node != null ? 1 : 0) != 0);
            String expected = valueOf.getText();
            String result = node.valueOf(valueOf.attributeValue("select"));
            this.log(description);
            this.log("\texpected: " + expected + " result: " + result);
            XPathExamplesTest.assertEquals((String)description, (String)expected, (String)result);
        }
    }

    protected void testValueOf(Metaset documentTest, Metaset context, Metaset valueOf) throws Exception {
        String xpath = valueOf.attributeValue("select");
        String description = "valueOf: " + xpath;
        String expected = valueOf.getText();
        String result = this.testContext.valueOf(xpath);
        this.log(description);
        this.log("\texpected: " + expected + " result: " + result);
        XPathExamplesTest.assertEquals((String)description, (String)expected, (String)result);
    }

    protected void testPattern(Metaset documentTest, Metaset context, Metaset patternElement) throws Exception {
        String match = patternElement.attributeValue("match");
        String description = "match: " + match;
        this.log("");
        this.log(description);
        Pattern pattern = this.factory.createPattern(match);
        XPathExamplesTest.assertTrue((String)description, (boolean)pattern.matches(this.testContext));
    }

    protected void testFilter(Metaset documentTest, Metaset context, Metaset pattern) throws Exception {
        String match = pattern.attributeValue("match");
        String description = "match: " + match;
        XPathExamplesTest.assertTrue((String)description, (boolean)this.testContext.matches(match));
    }
}

