/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import java.util.List;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentHelper;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.XPath;
import org.act.xservices.rt.xom.tree.DefaultElement;
import org.act.xservices.rt.xom.xpath.DefaultXPath;

public class XPathTest
extends AbstractTestCase {
    protected static String[] paths = new String[]{".", "*", "/", "/.", "/*", "/node()", "/child::node()", "/self::node()", "root", "/root", "/root/author", "text()", "//author", "//author/text()", "//@location", "//attribute::*", "//namespace::*", "normalize-space(/root)", "//author[@location]", "//author[@location='UK']", "root|author", "//*[.='James Strachan']", "//root/author[1]", "normalize-space(/root/author)", "normalize-space(' a  b  c  d ')", "//root|//author[1]|//author[2]", "//root/author[2]", "//root/author[3]"};

    public static void main(String[] args) {
        TestRunner.run(XPathTest.class);
    }

    public void testBug1116471() throws Exception {
        String xml = "<a><b>Water T &amp; D-46816</b></a>";
        String expected = "Water T & D-46816";
        Document doc = DocumentHelper.parseText(xml);
        String result = (String)doc.selectObject("string(a/b[1])");
        XPathTest.assertEquals((String)"xpath result not correct", (String)expected, (String)result);
        Node node = doc.selectSingleNode("a/b");
        String result2 = node.getStringValue();
        XPathTest.assertEquals((String)"xpath result not correct", (String)expected, (String)result2);
    }

    public void testXPaths() throws Exception {
        int size = paths.length;
        int i = 0;
        while (i < size) {
            this.testXPath(paths[i]);
            ++i;
        }
    }

    public void testCreateXPathBug() throws Exception {
        DefaultElement element = new DefaultElement("foo");
        XPath xpath = element.createXPath("//bar");
        XPathTest.assertTrue(("created a valid XPath: " + xpath != null ? 1 : 0) != 0);
    }

    public void testBug857704() throws Exception {
        Document doc = DocumentHelper.parseText("<foo xmlns:bar='http://blort'/>");
        doc.selectNodes("//*[preceding-sibling::*]");
    }

    public void testBooleanValueOf() throws Exception {
        Document doc = DocumentHelper.parseText("<root><foo>blah</foo></root>");
        DefaultXPath path = new DefaultXPath("//root");
        XPathTest.assertTrue((boolean)path.booleanValueOf(doc));
        path = new DefaultXPath("//root2");
        XPathTest.assertFalse((boolean)path.booleanValueOf(doc));
    }

    protected void testXPath(String xpathExpression) {
        this.log("Searched path: " + xpathExpression);
        XPath xpath = DocumentHelper.createXPath(xpathExpression);
        List<? extends Node> list = xpath.selectNodes(this.document);
        if (list == null) {
            this.log("null");
        } else {
            this.log("[");
            int i = 0;
            int size = list.size();
            while (i < size) {
                Node object = list.get(i);
                String text = "null";
                if (object instanceof Node) {
                    Node node = object;
                    text = node.asXML();
                } else if (object != null) {
                    text = object.toString();
                }
                this.log("    " + text);
                ++i;
            }
            this.log("]");
        }
        this.log("...........................................");
    }
}

