/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.io.DocumentResult;
import org.act.xservices.rt.xom.io.DocumentSource;

public class XSLTTest
extends AbstractTestCase {
    public static void main(String[] args) {
        TestRunner.run(XSLTTest.class);
    }

    public void testTransform() throws Exception {
        Document transformedDoc = this.transform("xml/nitf/ashtml.xsl");
        XSLTTest.assertTrue((String)"Transformed Document is not null", (transformedDoc != null ? 1 : 0) != 0);
        List<? extends Node> h1List = transformedDoc.selectNodes("/html//h1");
        XSLTTest.assertTrue((String)"At least one <h1>", (h1List.size() > 0 ? 1 : 0) != 0);
        List<? extends Node> pList = transformedDoc.selectNodes("//p");
        XSLTTest.assertTrue((String)"At least one <p>", (pList.size() > 0 ? 1 : 0) != 0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.document = this.getDocument("xml/nitf/sample.xml");
    }

    protected Document transform(String xsl) throws Exception {
        XSLTTest.assertTrue((String)"Document is not null", (this.document != null ? 1 : 0) != 0);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(this.getFile(xsl)));
        DocumentSource source = new DocumentSource(this.document);
        DocumentResult result = new DocumentResult();
        transformer.transform(source, result);
        return result.getDocument();
    }
}

