/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.bean;

import java.util.List;
import org.act.xservices.rt.xom.Attribute;
import org.act.xservices.rt.xom.DocumentFactory;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Namespace;
import org.act.xservices.rt.xom.QName;
import org.act.xservices.rt.xom.bean.BeanAttributeList;
import org.act.xservices.rt.xom.bean.BeanDocumentFactory;
import org.act.xservices.rt.xom.tree.DefaultElement;
import org.act.xservices.rt.xom.tree.NamespaceStack;
import org.xml.sax.Attributes;

public class BeanElement
extends DefaultElement {
    private static final DocumentFactory DOCUMENT_FACTORY = BeanDocumentFactory.getInstance();
    private Object bean;

    public BeanElement(String name, Object bean) {
        this(DOCUMENT_FACTORY.createQName(name), bean);
    }

    public BeanElement(String name, Namespace namespace, Object bean) {
        this(DOCUMENT_FACTORY.createQName(name, namespace), bean);
    }

    public BeanElement(QName qname, Object bean) {
        super(qname);
        this.bean = bean;
    }

    public BeanElement(QName qname) {
        super(qname);
    }

    public Object getData() {
        return this.bean;
    }

    public void setData(Object data) {
        this.bean = data;
        this.setAttributeList(null);
    }

    public Attribute attribute(String name) {
        return this.getBeanAttributeList().attribute(name);
    }

    public Attribute attribute(QName qname) {
        return this.getBeanAttributeList().attribute(qname);
    }

    public Metaset addAttribute(String name, String value) {
        Attribute attribute = this.attribute(name);
        if (attribute != null) {
            attribute.setValue(value);
        }
        return this;
    }

    public Metaset addAttribute(QName qName, String value) {
        Attribute attribute = this.attribute(qName);
        if (attribute != null) {
            attribute.setValue(value);
        }
        return this;
    }

    public void setAttributes(List attributes) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void setAttributes(Attributes attributes, NamespaceStack namespaceStack, boolean noNamespaceAttributes) {
        String className = attributes.getValue("class");
        if (className != null) {
            try {
                Class<?> beanClass = Class.forName(className, true, BeanElement.class.getClassLoader());
                this.setData(beanClass.newInstance());
                int i = 0;
                while (i < attributes.getLength()) {
                    String attributeName = attributes.getLocalName(i);
                    if (!"class".equalsIgnoreCase(attributeName)) {
                        this.addAttribute(attributeName, attributes.getValue(i));
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ((BeanDocumentFactory)this.getDocumentFactory()).handleException(ex);
            }
        } else {
            super.setAttributes(attributes, namespaceStack, noNamespaceAttributes);
        }
    }

    protected DocumentFactory getDocumentFactory() {
        return DOCUMENT_FACTORY;
    }

    protected BeanAttributeList getBeanAttributeList() {
        return (BeanAttributeList)this.attributeList();
    }

    protected List createAttributeList() {
        return new BeanAttributeList(this);
    }

    protected List createAttributeList(int size) {
        return new BeanAttributeList(this);
    }
}

