/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.datatype;

import com.sun.msv.datatype.xsd.XSDatatype;
import java.util.HashMap;
import java.util.Map;
import org.act.xservices.rt.xom.DocumentFactory;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.QName;
import org.act.xservices.rt.xom.datatype.DatatypeElementFactory;

class NamedTypeResolver {
    protected Map<QName, DocumentFactory> complexTypeMap = new HashMap<QName, DocumentFactory>();
    protected Map<QName, XSDatatype> simpleTypeMap = new HashMap<QName, XSDatatype>();
    protected Map<Metaset, QName> typedElementMap = new HashMap<Metaset, QName>();
    protected Map<Metaset, DocumentFactory> elementFactoryMap = new HashMap<Metaset, DocumentFactory>();
    protected DocumentFactory documentFactory;

    NamedTypeResolver(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    void registerComplexType(QName type, DocumentFactory factory) {
        this.complexTypeMap.put(type, factory);
    }

    void registerSimpleType(QName type, XSDatatype datatype) {
        this.simpleTypeMap.put(type, datatype);
    }

    void registerTypedElement(Metaset element, QName type, DocumentFactory parentFactory) {
        this.typedElementMap.put(element, type);
        this.elementFactoryMap.put(element, parentFactory);
    }

    void resolveElementTypes() {
        for (Map.Entry<Metaset, QName> entry : this.typedElementMap.entrySet()) {
            Metaset element = entry.getKey();
            QName elementQName = this.getQNameOfSchemaElement(element);
            QName type = entry.getValue();
            if (this.complexTypeMap.containsKey(type)) {
                DocumentFactory factory = this.complexTypeMap.get(type);
                elementQName.setDocumentFactory(factory);
                continue;
            }
            if (!this.simpleTypeMap.containsKey(type)) continue;
            XSDatatype datatype = this.simpleTypeMap.get(type);
            DocumentFactory factory = this.elementFactoryMap.get(element);
            if (!(factory instanceof DatatypeElementFactory)) continue;
            ((DatatypeElementFactory)factory).setChildElementXSDatatype(elementQName, datatype);
        }
    }

    void resolveNamedTypes() {
        this.resolveElementTypes();
    }

    private QName getQNameOfSchemaElement(Metaset element) {
        String name = element.attributeValue("name");
        return this.getQName(name);
    }

    private QName getQName(String name) {
        return this.documentFactory.createQName(name);
    }
}

