/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.datatype;

import java.math.BigInteger;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Attribute;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Namespace;
import org.act.xservices.rt.xom.QName;
import org.act.xservices.rt.xom.datatype.DatatypeAttribute;
import org.act.xservices.rt.xom.datatype.DatatypeDocumentFactory;

public class SetDataTest
extends AbstractTestCase {
    private DatatypeDocumentFactory factory = new DatatypeDocumentFactory();

    public static void main(String[] args) {
        TestRunner.run(SetDataTest.class);
    }

    public void testAttribute() throws Exception {
        QName personName = this.factory.createQName("person");
        QName ageName = this.factory.createQName("age");
        Metaset person = this.factory.createElement(personName);
        person.addAttribute(ageName, "10");
        Attribute age = person.attribute(ageName);
        SetDataTest.assertTrue((String)"Created DatatypeAttribute not correct", (boolean)(age instanceof DatatypeAttribute));
        this.log("Found attribute: " + age);
        Object data = age.getData();
        BigInteger expected = new BigInteger("10");
        SetDataTest.assertEquals((String)"Data is correct type", BigInteger.class, data.getClass());
        SetDataTest.assertEquals((String)"Set age correctly", (Object)expected, (Object)data);
        age.setValue("32");
        data = age.getData();
        expected = new BigInteger("32");
        SetDataTest.assertEquals((String)"Set age correctly", (Object)expected, (Object)data);
        try {
            age.setValue("abc");
            SetDataTest.fail((String)"Appeared to set an invalid value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAttributeWithNamespace() throws Exception {
        QName personName = this.factory.createQName("person", "t", "urn://testing");
        QName ageName = this.factory.createQName("age", "t", "urn://testing");
        Metaset person = this.factory.createElement(personName);
        person.addAttribute(ageName, "10");
        Attribute age = person.attribute(ageName);
        SetDataTest.assertTrue((String)"Created DatatypeAttribute not correct", (boolean)(age instanceof DatatypeAttribute));
        this.log("Found attribute: " + age);
        Object data = age.getData();
        BigInteger expected = new BigInteger("10");
        SetDataTest.assertEquals((String)"Data is correct type", BigInteger.class, data.getClass());
        SetDataTest.assertEquals((String)"Set age correctly", (Object)expected, (Object)data);
        age.setValue("32");
        data = age.getData();
        expected = new BigInteger("32");
        SetDataTest.assertEquals((String)"Set age correctly", (Object)expected, (Object)data);
        try {
            age.setValue("abc");
            SetDataTest.fail((String)"Appeared to set an invalid value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testElement() throws Exception {
        QName personName = this.factory.createQName("person");
        QName numberOfCarsName = this.factory.createQName("numberOfCars");
        Metaset person = this.factory.createElement(personName);
        Metaset cars = person.addElement(numberOfCarsName);
        this.log("Found element: " + cars);
        Short expected = new Short(10);
        cars.setData(expected);
        Object data = cars.getData();
        SetDataTest.assertEquals((String)"Data is correct type", Short.class, data.getClass());
        SetDataTest.assertEquals((String)"Set cars correctly", (Object)expected, (Object)data);
        cars.setData(new Short(32));
        data = cars.getData();
        expected = new Short(32);
        SetDataTest.assertEquals((String)"Set cars correctly", (Object)expected, (Object)data);
        cars.setText("34");
        data = cars.getData();
        expected = new Short(34);
        SetDataTest.assertEquals((String)"Set cars correctly", (Object)expected, (Object)data);
        try {
            cars.setText("abc");
            SetDataTest.fail((String)"Appeared to set an invalid value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        Document schema = this.getDocument("xml/test/schema/personal.xsd");
        this.factory.loadSchema(schema);
        Namespace ns = new Namespace("t", "urn://testing");
        this.factory.loadSchema(schema, ns);
    }
}

