/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.dom;

import java.io.StringReader;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.dom.DOMDocument;
import org.act.xservices.rt.xom.dom.DOMDocumentFactory;
import org.act.xservices.rt.xom.io.DOMWriter;
import org.act.xservices.rt.xom.io.SAXReader;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMTest
extends AbstractTestCase {
    private long elements;
    private long attributes;
    private long characters;

    public static void main(String[] args) {
        TestRunner.run(DOMTest.class);
    }

    public void testCount() throws Exception {
        DOMWriter domWriter = new DOMWriter();
        long start = System.currentTimeMillis();
        Document domDocument = domWriter.write(this.document);
        long end = System.currentTimeMillis();
        System.out.println("Converting to a W3C Document took: " + (end - start) + " milliseconds");
        this.traverse(domDocument);
        this.log("elements: " + this.elements + " attributes: " + this.attributes + " characters: " + this.characters);
    }

    public void testNamespace() throws Exception {
        String xml = "<prefix:root xmlns:prefix=\"myuri\" />";
        SAXReader xmlReader = new SAXReader(DOMDocumentFactory.getInstance());
        DOMDocument d = (DOMDocument)xmlReader.read(new StringReader(xml));
        DOMTest.assertEquals((String)"namespace prefix not correct", (String)"prefix", (String)d.getRootElement().getNamespace().getPrefix());
        DOMTest.assertEquals((String)"namespace uri not correct", (String)"myuri", (String)d.getRootElement().getNamespace().getURI());
        System.out.println(d.asXML());
    }

    public void testClassCastBug() throws Exception {
        DOMDocument oDocument = new DOMDocument("Root");
        Element oParent = oDocument.createElement("Parent");
        oParent.setAttribute("name", "N01");
        oParent.setAttribute("id", "ID01");
        oDocument.appendChild(oParent);
    }

    public void testReplaceChild() throws Exception {
        DOMDocument document = new DOMDocument("Root");
        Element parent = document.createElement("Parent");
        Element first = document.createElement("FirstChild");
        Element second = document.createElement("SecondChild");
        Element third = document.createElement("ThirdChild");
        document.appendChild(parent);
        parent.appendChild(first);
        parent.appendChild(second);
        parent.appendChild(third);
        Element newFirst = document.createElement("NewFirst");
        Element oldFirst = (Element)parent.replaceChild(newFirst, first);
        DOMTest.assertEquals((Object)oldFirst, (Object)first);
        NodeList children = parent.getChildNodes();
        Node firstChild = children.item(0);
        DOMTest.assertEquals((short)1, (short)firstChild.getNodeType());
        DOMTest.assertEquals((Object)newFirst, (Object)firstChild);
        Element badNode = document.createElement("No Child");
        try {
            parent.replaceChild(newFirst, badNode);
            DOMTest.fail((String)"DOMException not thrown");
        }
        catch (DOMException e) {
            DOMTest.assertEquals((short)8, (short)e.code);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        SAXReader reader = new SAXReader(DOMDocumentFactory.getInstance());
        this.document = this.getDocument("xml/contents.xml", reader);
    }

    protected void traverse(Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                this.elements = 0L;
                this.attributes = 0L;
                this.characters = 0L;
                this.traverse(((Document)node).getDocumentElement());
                break;
            }
            case 1: {
                NodeList children;
                ++this.elements;
                NamedNodeMap attrs = node.getAttributes();
                if (attrs != null) {
                    this.attributes += (long)attrs.getLength();
                }
                if ((children = node.getChildNodes()) == null) break;
                int len = children.getLength();
                int i = 0;
                while (i < len) {
                    this.traverse(children.item(i));
                    ++i;
                }
                break;
            }
            case 5: {
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                int i = 0;
                while (i < len) {
                    this.traverse(children.item(i));
                    ++i;
                }
                break;
            }
            case 4: {
                this.characters += (long)node.getNodeValue().length();
                break;
            }
            case 3: {
                this.characters += (long)node.getNodeValue().length();
                break;
            }
        }
    }
}

