/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.impl.stax;

import java.io.InputStream;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.act.xservices.rt.metaset.MetasetBuilder;
import org.act.xservices.rt.metaset.MetasetParserFactory;
import org.act.xservices.rt.xom.Attribute;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.QName;

public class MetasetImplTest
extends TestCase {
    private Metaset metaset = null;
    private static MetasetBuilder builder = new MetasetBuilder();

    public MetasetImplTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        InputStream in = MetasetImplTest.class.getClassLoader().getResourceAsStream("textFile/MetasetImplTest_Sample.xml");
        this.metaset = MetasetParserFactory.getStAXParser().parse(in);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.metaset = null;
    }

    public void testGetNamespaceURI() {
        MetasetImplTest.assertEquals((String)"www.namespace", (String)this.metaset.getNamespaceURI());
        MetasetImplTest.assertEquals((String)"", (String)this.metaset.elements().get(0).getNamespaceURI());
    }

    public void testGetFullStringName() {
        MetasetImplTest.assertEquals((String)"{www.namespace}personnel", (String)this.metaset.getFullStringName());
        MetasetImplTest.assertEquals((String)"person", (String)this.metaset.elements().get(0).getFullStringName());
    }

    public void testgetNamespacePrefix() {
        MetasetImplTest.assertEquals((String)"xsd", (String)this.metaset.getNamespacePrefix());
        MetasetImplTest.assertEquals((String)"", (String)this.metaset.elements().get(0).getNamespacePrefix());
    }

    public void testgetName() {
        MetasetImplTest.assertEquals((String)"personnel", (String)this.metaset.getName());
        MetasetImplTest.assertEquals((String)"person", (String)this.metaset.elements().get(0).getName());
    }

    public void testGetQName() {
        QName qName = new QName("www.namespace", "personnel", "xsd");
        MetasetImplTest.assertEquals((Object)qName, (Object)this.metaset.getQName());
        qName = new QName("", "person", "");
        MetasetImplTest.assertEquals((Object)qName, (Object)this.metaset.elements().get(0).getQName());
    }

    public void testgetParent() {
        MetasetImplTest.assertEquals(null, (Object)this.metaset.getParent());
        MetasetImplTest.assertEquals((Object)this.metaset, (Object)this.metaset.elements().get(0).getParent());
    }

    public void testAttributes() {
        Attribute attr1 = this.metaset.attributes().get(0);
        MetasetImplTest.assertEquals((String)"http://act.org", (String)attr1.getNamespaceURI());
        MetasetImplTest.assertEquals((String)"act", (String)attr1.getNamespacePrefix());
        MetasetImplTest.assertEquals((String)"version", (String)attr1.getName());
        MetasetImplTest.assertEquals((String)"1.0", (String)attr1.getValue());
        Attribute attr00 = this.metaset.elements().get(0).attributes().get(0);
        MetasetImplTest.assertEquals((String)"", (String)attr00.getNamespaceURI());
        MetasetImplTest.assertEquals((String)"", (String)attr00.getNamespacePrefix());
        MetasetImplTest.assertEquals((String)"id", (String)attr00.getName());
        MetasetImplTest.assertEquals((String)"Big.Boss", (String)attr00.getValue());
    }

    public void testFilter() {
        MetasetImplTest.assertEquals(null, (Object)this.metaset.filter(".\\person@id='three.worker'"));
        MetasetImplTest.assertEquals(null, (Object)this.metaset.filter(""));
        MetasetImplTest.assertEquals((String)this.metaset.elements().get(2).toXML(), (String)this.metaset.filter(".\\person@id='two.worker'").toXML());
        MetasetImplTest.assertEquals((String)this.metaset.toXML(), (String)this.metaset.filter("personnel").toXML());
        MetasetImplTest.assertEquals((String)this.metaset.elements().get(1).toXML(), (String)this.metaset.filter("personnel\\person@id='one.worker'").toXML());
        MetasetImplTest.assertEquals((String)this.metaset.toXML(), (String)this.metaset.filter("*").toXML());
        MetasetImplTest.assertEquals((String)this.metaset.toXML(), (String)this.metaset.filter("*@xmlns:xsd").toXML());
        MetasetImplTest.assertEquals((String)this.metaset.toXML(), (String)this.metaset.filter("*@xsd").toXML());
        MetasetImplTest.assertEquals(null, (Object)this.metaset.filter("*@xmlns"));
        MetasetImplTest.assertEquals((String)this.metaset.toXML(), (String)this.metaset.filter("*@xsd='www.namespace'").toXML());
        MetasetImplTest.assertEquals(null, (Object)this.metaset.filter("*@xmlns='www.namespace'"));
        MetasetImplTest.assertEquals(null, (Object)this.metaset.filter("*@id='one.worker'"));
        MetasetImplTest.assertEquals(null, (Object)this.metaset.filter("given"));
        MetasetImplTest.assertEquals((String)this.metaset.elements().get(1).toXML(), (String)this.metaset.filter("personnel\\*@id='one.worker'").toXML());
        MetasetImplTest.assertEquals(null, (Object)this.metaset.filter("personnel\\*@id=' '"));
        MetasetImplTest.assertEquals(null, (Object)this.metaset.filter("person@id='one.worker'"));
        MetasetImplTest.assertEquals((String)this.metaset.toXML(), (String)this.metaset.filter(".").toXML());
        MetasetImplTest.assertEquals((String)this.metaset.toXML(), (String)this.metaset.filter(".@xmlns:xsd").toXML());
        MetasetImplTest.assertEquals(null, (Object)this.metaset.filter(".@xmlns"));
        MetasetImplTest.assertEquals((String)this.metaset.toXML(), (String)this.metaset.filter(".@xsd").toXML());
        MetasetImplTest.assertEquals((String)this.metaset.toXML(), (String)this.metaset.filter(".@xsd='www.namespace'").toXML());
        MetasetImplTest.assertEquals(null, (Object)this.metaset.filter(".\\person\\name\\family\\*"));
        MetasetImplTest.assertNotNull((Object)this.metaset.filter(".\\*\\name\\*"));
        MetasetImplTest.assertNotNull((Object)this.metaset.filter(".\\*\\address\\street\\*"));
        MetasetImplTest.assertEquals((String)this.metaset.elements().get(3).elements().get(1).elements().get(1).toXML(), (String)this.metaset.filter(".\\*\\*\\street").toXML());
        MetasetImplTest.assertEquals((String)this.metaset.elements().get(3).elements().get(1).elements().get(1).toXML(), (String)this.metaset.filter(".\\building\\address\\street").toXML());
        MetasetImplTest.assertEquals((String)this.metaset.elements().get(3).elements().get(1).elements().get(1).toXML(), (String)this.metaset.filter(".\\building\\addr:address\\street").toXML());
        MetasetImplTest.assertEquals((String)this.metaset.elements().get(3).elements().get(1).elements().get(1).toXML(), (String)this.metaset.filter(".\\building\\{www.namespace/building/address}address\\street").toXML());
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.metaset.elements().size()) {
            sb.append(this.metaset.elements().get(i).toXML());
            ++i;
        }
        MetasetImplTest.assertEquals((String)sb.toString(), (String)this.metaset.filter(".\\*").toXML());
    }

    public void testSelectorElementName() {
        MetasetImplTest.assertEquals((Object)new QName("www.namespace", "personnel", "xsd"), (Object)this.metaset.selectorElementName("."));
        MetasetImplTest.assertEquals((Object)new QName("www.namespace", "personnel", "xsd"), (Object)this.metaset.selectorElementName("*"));
        MetasetImplTest.assertNull((Object)this.metaset.selectorElementName(".\\somethingNotExist\\*"));
        MetasetImplTest.assertNull((Object)this.metaset.selectorElementName(".\\person\\name\\family\\*"));
        MetasetImplTest.assertEquals(null, (Object)this.metaset.selectorElementName(".\\person\\*\\*\\*"));
        MetasetImplTest.assertEquals((Object)new QName("www.namespace/building/address/street/number", "code", ""), (Object)this.metaset.selectorElementName(".\\*\\*\\*\\*\\code"));
        MetasetImplTest.assertEquals((Object)new QName("www.namespace/building/address/street/number", "code", ""), (Object)this.metaset.selectorElementName(".\\*\\*\\*\\*\\*"));
        MetasetImplTest.assertEquals((Object)new QName("", "person", ""), (Object)this.metaset.selectorElementName(".\\*"));
        MetasetImplTest.assertEquals((Object)new QName("", "family", ""), (Object)this.metaset.selectorElementName(".\\person\\name\\*"));
        MetasetImplTest.assertEquals((Object)new QName("", "family", ""), (Object)this.metaset.selectorElementName(".\\person\\*\\*"));
        MetasetImplTest.assertEquals((Object)new QName("", "family", ""), (Object)this.metaset.selectorElementName(".\\person@id='one.worker'\\name\\*"));
        MetasetImplTest.assertEquals((Object)new QName("", "family", ""), (Object)this.metaset.selectorElementName(".\\person\\name\\*"));
    }

    public void testSelectorsElementName() {
        ArrayList<QName> list1 = new ArrayList<QName>();
        list1.add(new QName("www.namespace", "personnel", "xsd"));
        MetasetImplTest.assertEquals(list1, this.metaset.selectorsElementName("."));
        ArrayList<QName> list2 = new ArrayList<QName>();
        list2.add(new QName("www.namespace/building/address/street/number", "number", ""));
        MetasetImplTest.assertEquals(list2, this.metaset.selectorsElementName(".\\building\\address\\street\\number"));
        ArrayList<QName> list3 = new ArrayList<QName>();
        list3.add(new QName("www.namespace/building/address/street/number", "number", ""));
        MetasetImplTest.assertEquals(list3, this.metaset.selectorsElementName(".\\building\\addr:address\\street\\number"));
        ArrayList<QName> list4 = new ArrayList<QName>();
        list4.add(new QName("www.namespace/building/address/street/number", "number", ""));
        MetasetImplTest.assertEquals(list4, this.metaset.selectorsElementName(".\\building\\{www.namespace/building/address}address\\street\\number"));
        ArrayList<QName> list5 = new ArrayList<QName>();
        list5.add(new QName("www.namespace/building/address/street/number", "number", ""));
        MetasetImplTest.assertEquals(list5, this.metaset.selectorsElementName(".\\building\\address\\street\\number"));
        ArrayList<QName> list6 = new ArrayList<QName>();
        list6.add(new QName("", "name", ""));
        list6.add(new QName("", "name", ""));
        list6.add(new QName("", "name", ""));
        list6.add(new QName("", "name", ""));
        list6.add(new QName("www.namespace/company/register/name", "name", "regName"));
        MetasetImplTest.assertEquals(list6, this.metaset.selectorsElementName(".\\*\\name"));
        ArrayList<QName> list7 = new ArrayList<QName>();
        list7.add(new QName("", "person", ""));
        list7.add(new QName("", "person", ""));
        list7.add(new QName("", "person", ""));
        list7.add(new QName("www.namespace/building", "building", "build"));
        list7.add(new QName("www.namespace/company", "company", "xsd"));
        MetasetImplTest.assertEquals(list7, this.metaset.selectorsElementName(".\\*"));
    }

    public void testSelectorAttributeValue() {
        MetasetImplTest.assertEquals((String)"www.namespace", (String)this.metaset.selectorAttributeValue(".", "xsd"));
        MetasetImplTest.assertEquals((String)"www.namespace/building/address/street/number", (String)this.metaset.selectorAttributeValue(".\\*\\*\\*\\*", "*"));
        MetasetImplTest.assertEquals((String)"www.namespace/building/address/street/number", (String)this.metaset.selectorAttributeValue(".\\building\\*\\*\\*", "*"));
        MetasetImplTest.assertEquals((String)"www.namespace/building/address/street/number", (String)this.metaset.selectorAttributeValue(".\\building\\addr:address\\*\\*", "*"));
        MetasetImplTest.assertEquals((String)"www.namespace/building/address/street/number", (String)this.metaset.selectorAttributeValue(".\\{www.namespace/building}building\\*\\*\\*", "*"));
        MetasetImplTest.assertEquals(null, (String)this.metaset.selectorAttributeValue(".\\*", "xsd"));
        MetasetImplTest.assertEquals((String)"www.namespace", (String)this.metaset.selectorAttributeValue(".", "xmlns:xsd"));
    }

    public void testSelectorsAttributeValue() {
        ArrayList<String> list = null;
        list = new ArrayList<String>();
        list.add("www.namespace/building/address/street/number");
        MetasetImplTest.assertEquals(list, this.metaset.selectorsAttributeValue(".\\*\\*\\*\\*", "*"));
        list = new ArrayList();
        list.add("www.namespace/company");
        MetasetImplTest.assertEquals(list, this.metaset.selectorsAttributeValue(".\\*", "xsd"));
        list = new ArrayList();
        list.add("Big.Boss");
        list.add("one.worker");
        list.add("two.worker");
        MetasetImplTest.assertEquals(list, this.metaset.selectorsAttributeValue(".\\person", "id"));
    }

    public void testAddAttribute() {
        this.metaset.add(builder.newAttribute(new QName("http://www.w3.org/2000/xmlns/", "xsd", "xmlns"), "www.namespace"));
        this.metaset.add(builder.newAttribute(new QName("", "id", ""), "id-personnel"));
        MetasetImplTest.assertEquals((String)"id-personnel", (String)this.metaset.selectorAttributeValue(".", "id"));
        MetasetImplTest.assertEquals((String)"id-personnel", (String)this.metaset.selectorAttributeValue(".", "id"));
        this.metaset.add(builder.newAttribute(new QName("www.namespace", "link", "xsd"), "link-personnel"));
        MetasetImplTest.assertEquals((String)"link-personnel", (String)this.metaset.selectorAttributeValue(".", "link"));
        MetasetImplTest.assertEquals((String)"link-personnel", (String)this.metaset.selectorAttributeValue(".", "xsd:link"));
        MetasetImplTest.assertEquals((String)"link-personnel", (String)this.metaset.selectorAttributeValue(".", "{www.namespace}link"));
    }

    public void testAddChildren() {
        this.metaset.add(this.metaset);
        this.metaset.add((Metaset)this.metaset.elements().get(0).clone());
        ArrayList<String> list = new ArrayList<String>();
        list.add("Big.Boss");
        list.add("Big.Boss");
        MetasetImplTest.assertEquals(list, this.metaset.selectorsAttributeValue(".\\*@id='Big.Boss'", "id"));
        MetasetImplTest.assertEquals(list, this.metaset.selectorsAttributeValue(".\\*@id='Big.Boss'", "id"));
    }

    public void testAttribute1() {
        MetasetImplTest.assertFalse((boolean)this.metaset.addAttribute(".\\person\\manager", builder.newAttribute(new QName("", "", ""), "")));
        MetasetImplTest.assertTrue((boolean)this.metaset.addAttribute(".\\person", builder.newAttribute(new QName("", "gender", ""), "mail")));
        ArrayList<String> list = new ArrayList<String>();
        list.add("mail");
        list.add("mail");
        list.add("mail");
        MetasetImplTest.assertEquals(list, this.metaset.selectorsAttributeValue(".\\*@id", "gender"));
        MetasetImplTest.assertTrue((boolean)this.metaset.addAttribute(".\\*@id\\*\\family", builder.newAttribute(new QName("www.namespace", "nns", "xsd"), "family-name-ns")));
        list = new ArrayList();
        list.add("family-name-ns");
        list.add("family-name-ns");
        list.add("family-name-ns");
        MetasetImplTest.assertEquals(list, this.metaset.selectorsAttributeValue(".\\*\\*\\family", "nns"));
        MetasetImplTest.assertEquals(list, this.metaset.selectorsAttributeValue(".\\*\\*\\family", "nns"));
        MetasetImplTest.assertEquals(list, this.metaset.selectorsAttributeValue(".\\*\\*\\family", "nns"));
        MetasetImplTest.assertEquals(list, this.metaset.selectorsAttributeValue(".\\*\\*\\family", "xsd:nns"));
        MetasetImplTest.assertEquals(list, this.metaset.selectorsAttributeValue(".\\*\\*\\family", "{www.namespace}nns"));
    }

    public void testadd1() {
        MetasetImplTest.assertFalse((boolean)this.metaset.addChildren(".\\person\\manager", this.metaset));
        MetasetImplTest.assertTrue((boolean)this.metaset.addChildren(".\\*@id", this.metaset));
        ArrayList<QName> list = new ArrayList<QName>();
        list.add(new QName("www.namespace", "personnel", "xsd"));
        list.add(new QName("www.namespace", "personnel", "xsd"));
        list.add(new QName("www.namespace", "personnel", "xsd"));
        MetasetImplTest.assertEquals(list, this.metaset.selectorsElementName(".\\*@id\\personnel"));
        MetasetImplTest.assertNull((Object)this.metaset.filter(".\\person\\personnel\\person\\personnel\\person\\personnel\\person\\personnel"));
        MetasetImplTest.assertFalse((boolean)this.metaset.addChildren(".\\*@id", null));
        MetasetImplTest.assertEquals(list, this.metaset.selectorsElementName(".\\*@id\\personnel"));
    }

    public void testRemoveAttribute() {
        MetasetImplTest.assertFalse((boolean)this.metaset.remove(builder.newAttribute(new QName("", "", ""), "")));
    }

    public void testRemoveChildren() {
        MetasetImplTest.assertTrue((boolean)this.metaset.removeChildren(this.metaset.elements().get(0)));
        MetasetImplTest.assertNull((Object)this.metaset.filter(".\\*@id='Big.Boss'"));
    }

    public void testRemoveAttribute1() {
        MetasetImplTest.assertFalse((boolean)this.metaset.removeAttribute(".\\person\\manager", null));
        MetasetImplTest.assertFalse((boolean)this.metaset.removeAttribute(".\\*", null));
        MetasetImplTest.assertNotNull((Object)this.metaset.elements().get(1).selectorAttributeValue(".", "id"));
        MetasetImplTest.assertNotNull((Object)this.metaset.elements().get(2).selectorAttributeValue(".", "id"));
        MetasetImplTest.assertNotNull((Object)this.metaset.elements().get(0).selectorAttributeValue(".", "id"));
    }

    public void testRemoveChildren1() {
        MetasetImplTest.assertFalse((boolean)this.metaset.removeChildren(".\\manager", null));
        MetasetImplTest.assertTrue((boolean)this.metaset.removeChildren(".\\person", this.metaset));
        MetasetImplTest.assertTrue((boolean)this.metaset.removeChildren(".\\*@id", this.metaset.elements().get(0).elements().get(0)));
        MetasetImplTest.assertNotNull((Object)this.metaset.elements().get(1).filter(".\\name"));
        MetasetImplTest.assertNotNull((Object)this.metaset.elements().get(2).filter(".\\name"));
        MetasetImplTest.assertNull((Object)this.metaset.elements().get(0).filter(".\\name"));
    }

    public void testGetHeight() {
        MetasetImplTest.assertEquals((int)5, (int)this.metaset.getHeight());
        Metaset mt = this.metaset.filter(".\\person\\name\\given");
        MetasetImplTest.assertEquals((int)1, (int)mt.getHeight());
        mt = this.metaset.filter(".\\person\\name");
        MetasetImplTest.assertEquals((int)2, (int)mt.getHeight());
        mt = this.metaset.filter(".\\person");
        MetasetImplTest.assertEquals((int)3, (int)mt.getHeight());
    }

    public void testGetLeafCount() {
        MetasetImplTest.assertEquals((int)17, (int)this.metaset.getLeafCount());
        Metaset mt = this.metaset.filter(".\\person\\name\\given");
        MetasetImplTest.assertEquals((int)3, (int)mt.getLeafCount());
        mt = this.metaset.filter(".\\person\\name");
        MetasetImplTest.assertEquals((int)6, (int)mt.getLeafCount());
        mt = this.metaset.filter(".\\person");
        MetasetImplTest.assertEquals((int)12, (int)mt.getLeafCount());
    }
}

