/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.impl.xpath;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import junit.framework.TestCase;
import org.act.xservices.rt.metaset.MetasetBuilder;
import org.act.xservices.rt.metaset.MetasetParserFactory;
import org.act.xservices.rt.metaset.exception.MetasetParsingException;
import org.act.xservices.rt.xom.Attribute;
import org.act.xservices.rt.xom.DocumentHelper;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.XPath;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.xml.sax.SAXException;

public class BaseXPathTest
extends TestCase {
    private Metaset metaset;
    private static MetasetBuilder builder;

    public BaseXPathTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        builder = new MetasetBuilder();
        this.metaset = builder.newMetaset("root");
    }

    public void testParentOfSelection() throws JaxenException {
        XPath xpath = DocumentHelper.createXPath("(.//html/a/img[contains(@src,'gif')])[2]");
        Metaset html = builder.newMetaset("html");
        Metaset a1 = builder.newMetaset("a");
        Metaset a2 = builder.newMetaset("a");
        Metaset img1 = builder.newMetaset("img");
        Attribute img1_src = builder.newAttribute("src", "1.gif");
        Metaset img2 = builder.newMetaset("img");
        Attribute img2_src = builder.newAttribute("src", "2.gif");
        img1.add(img1_src);
        img2.add(img2_src);
        a1.add(img1);
        a2.add(img2);
        html.add(a1);
        html.add(a2);
        this.metaset.add(html);
        List<? extends Node> result = xpath.selectNodes(this.metaset);
        BaseXPathTest.assertEquals((int)1, (int)result.size());
    }

    public void testAncestorAxis() throws JaxenException {
        XPath xpath = DocumentHelper.createXPath("ancestor::*");
        Metaset root = builder.newMetaset("root");
        Metaset parent = builder.newMetaset("parent");
        this.metaset.add(root);
        Metaset child = builder.newMetaset("child");
        root.add(parent);
        parent.add(child);
        List<? extends Node> result = xpath.selectNodes(child);
        result.remove(this.metaset);
        BaseXPathTest.assertEquals((int)2, (int)result.size());
        BaseXPathTest.assertEquals((Object)root, (Object)result.get(0));
        BaseXPathTest.assertEquals((Object)parent, (Object)result.get(1));
        this.metaset.elements().clear();
    }

    public void testPrecedingSiblingAxisIsInDocumentOrder() throws JaxenException {
        XPath xpath = DocumentHelper.createXPath("preceding-sibling::*");
        Metaset root = builder.newMetaset("root");
        this.metaset.add(root);
        root.setParent(this.metaset);
        Metaset child1 = builder.newMetaset("child1");
        root.add(child1);
        child1.setParent(root);
        Metaset child2 = builder.newMetaset("child2");
        root.add(child2);
        child2.setParent(root);
        Metaset child3 = builder.newMetaset("child3");
        root.add(child3);
        child3.setParent(root);
        List<? extends Node> result = xpath.selectNodes(child3);
        BaseXPathTest.assertEquals((int)2, (int)result.size());
        BaseXPathTest.assertEquals((Object)child1, (Object)result.get(0));
        BaseXPathTest.assertEquals((Object)child2, (Object)result.get(1));
        this.metaset.elements().clear();
    }

    public void testPrecedingAxisIsInDocumentOrder() throws JaxenException {
        XPath xpath = DocumentHelper.createXPath("preceding::*");
        Metaset root = builder.newMetaset("root");
        this.metaset.add(root);
        root.setParent(this.metaset);
        Metaset parent1 = builder.newMetaset("parent1");
        root.add(parent1);
        parent1.setParent(root);
        Metaset parent2 = builder.newMetaset("parent2");
        root.add(parent2);
        parent2.setParent(root);
        Metaset child1 = builder.newMetaset("child1");
        parent2.add(child1);
        child1.setParent(parent2);
        Metaset child2 = builder.newMetaset("child2");
        parent2.add(child2);
        child2.setParent(parent2);
        Metaset child3 = builder.newMetaset("child3");
        parent2.add(child3);
        child3.setParent(parent2);
        List<? extends Node> result = xpath.selectNodes(child3);
        BaseXPathTest.assertEquals((int)3, (int)result.size());
        BaseXPathTest.assertEquals((Object)parent1, (Object)result.get(0));
        BaseXPathTest.assertEquals((Object)child1, (Object)result.get(1));
        BaseXPathTest.assertEquals((Object)child2, (Object)result.get(2));
        this.metaset.elements().clear();
    }

    public void testPrecedingAxisWithPositionalPredicate() throws JaxenException {
        XPath xpath = DocumentHelper.createXPath("preceding::*[1]");
        Metaset root = builder.newMetaset("root");
        this.metaset.add(root);
        root.setParent(this.metaset);
        Metaset child1 = builder.newMetaset("child1");
        root.add(child1);
        child1.setParent(root);
        Metaset child2 = builder.newMetaset("child2");
        root.add(child2);
        child2.setParent(root);
        Metaset child3 = builder.newMetaset("child3");
        root.add(child3);
        child3.setParent(root);
        List<? extends Node> result = xpath.selectNodes(child3);
        BaseXPathTest.assertEquals((int)1, (int)result.size());
        BaseXPathTest.assertEquals((Object)child2, (Object)result.get(0));
        this.metaset.elements().clear();
    }

    public void testAncestorAxisWithPositionalPredicate() throws JaxenException {
        XPath xpath = DocumentHelper.createXPath("ancestor::*[1]");
        Metaset root = builder.newMetaset("root");
        this.metaset.add(root);
        root.setParent(this.metaset);
        Metaset child1 = builder.newMetaset("child1");
        root.add(child1);
        child1.setParent(root);
        Metaset child2 = builder.newMetaset("child2");
        child1.add(child2);
        child2.setParent(child1);
        Metaset child3 = builder.newMetaset("child3");
        child2.add(child3);
        child3.setParent(child2);
        List<? extends Node> result = xpath.selectNodes(child3);
        BaseXPathTest.assertEquals((int)1, (int)result.size());
        BaseXPathTest.assertEquals((Object)child2, (Object)result.get(0));
        this.metaset.elements().clear();
    }

    public void testAncestorOrSelfAxis() throws JaxenException {
        XPath xpath = DocumentHelper.createXPath("ancestor-or-self::*");
        Metaset root = builder.newMetaset("root");
        Metaset parent = builder.newMetaset("parent");
        this.metaset.add(root);
        root.setParent(this.metaset);
        Metaset child = builder.newMetaset("child");
        root.add(parent);
        parent.setParent(root);
        parent.add(child);
        child.setParent(parent);
        List<? extends Node> result = xpath.selectNodes(child);
        result.remove(this.metaset);
        BaseXPathTest.assertEquals((int)3, (int)result.size());
        BaseXPathTest.assertEquals((Object)root, (Object)result.get(0));
        BaseXPathTest.assertEquals((Object)parent, (Object)result.get(1));
        BaseXPathTest.assertEquals((Object)child, (Object)result.get(2));
        this.metaset.elements().clear();
    }

    public void testAbbreviatedDoubleSlashAxis() throws JaxenException {
        XPath xpath = DocumentHelper.createXPath(".//x");
        Metaset a = builder.newMetaset("a");
        Metaset b = builder.newMetaset("b");
        this.metaset.add(a);
        Metaset x1 = builder.newMetaset("x");
        a.add(x1);
        a.add(b);
        Metaset x2 = builder.newMetaset("x");
        Metaset x3 = builder.newMetaset("x");
        Metaset x4 = builder.newMetaset("x");
        a.add(x4);
        b.add(x2);
        b.add(x3);
        List<? extends Node> result = xpath.selectNodes(this.metaset);
        BaseXPathTest.assertEquals((int)4, (int)result.size());
        BaseXPathTest.assertEquals((Object)x1, (Object)result.get(0));
        BaseXPathTest.assertEquals((Object)x2, (Object)result.get(1));
        BaseXPathTest.assertEquals((Object)x3, (Object)result.get(2));
        BaseXPathTest.assertEquals((Object)x4, (Object)result.get(3));
        this.metaset.elements().clear();
    }

    public void testAncestorFollowedByChildren() throws JaxenException {
        XPath xpath = DocumentHelper.createXPath("./a/b/x/ancestor::*/child::x");
        Metaset a = builder.newMetaset("a");
        Metaset b = builder.newMetaset("b");
        this.metaset.add(a);
        a.setParent(this.metaset);
        Metaset x1 = builder.newMetaset("x");
        a.add(x1);
        x1.setParent(a);
        a.add(b);
        b.setParent(a);
        Metaset x2 = builder.newMetaset("x");
        Metaset x3 = builder.newMetaset("x");
        Metaset x4 = builder.newMetaset("x");
        a.add(x4);
        x4.setParent(a);
        b.add(x2);
        x2.setParent(b);
        b.add(x3);
        x3.setParent(b);
        List<? extends Node> result = xpath.selectNodes(this.metaset);
        BaseXPathTest.assertEquals((int)4, (int)result.size());
        BaseXPathTest.assertEquals((Object)x1, (Object)result.get(0));
        BaseXPathTest.assertEquals((Object)x2, (Object)result.get(1));
        BaseXPathTest.assertEquals((Object)x3, (Object)result.get(2));
        BaseXPathTest.assertEquals((Object)x4, (Object)result.get(3));
        this.metaset.elements().clear();
    }

    public void testDescendantAxis() throws JaxenException {
        XPath xpath = DocumentHelper.createXPath("./descendant::x");
        Metaset a = builder.newMetaset("a");
        Metaset b = builder.newMetaset("b");
        this.metaset.add(a);
        a.setParent(this.metaset);
        Metaset x1 = builder.newMetaset("x");
        a.add(x1);
        x1.setParent(a);
        a.add(b);
        b.setParent(a);
        Metaset x2 = builder.newMetaset("x");
        Metaset x3 = builder.newMetaset("x");
        Metaset x4 = builder.newMetaset("x");
        a.add(x4);
        x4.setParent(a);
        b.add(x2);
        x2.setParent(b);
        b.add(x3);
        x3.setParent(b);
        List<? extends Node> result = xpath.selectNodes(this.metaset);
        BaseXPathTest.assertEquals((int)4, (int)result.size());
        BaseXPathTest.assertEquals((Object)x1, (Object)result.get(0));
        BaseXPathTest.assertEquals((Object)x2, (Object)result.get(1));
        BaseXPathTest.assertEquals((Object)x3, (Object)result.get(2));
        BaseXPathTest.assertEquals((Object)x4, (Object)result.get(3));
        this.metaset.elements().clear();
    }

    public void testDescendantAxisWithAttributes() throws JaxenException {
        XPath xpath = DocumentHelper.createXPath("./descendant::x/@*");
        Metaset a = builder.newMetaset("a");
        Metaset b = builder.newMetaset("b");
        this.metaset.add(a);
        a.setParent(this.metaset);
        Metaset x1 = builder.newMetaset("x");
        a.add(x1);
        x1.setParent(a);
        a.add(b);
        b.setParent(a);
        Metaset x2 = builder.newMetaset("x");
        Metaset x3 = builder.newMetaset("x");
        Metaset x4 = builder.newMetaset("x");
        a.add(x4);
        x4.setParent(a);
        b.add(x2);
        x2.setParent(b);
        b.add(x3);
        x3.setParent(b);
        Attribute a1 = builder.newAttribute("name", "1");
        x1.add(a1);
        Attribute a2 = builder.newAttribute("name", "2");
        x2.add(a2);
        Attribute a3 = builder.newAttribute("name", "3");
        x3.add(a3);
        Attribute a4 = builder.newAttribute("name", "4");
        x4.add(a4);
        List<? extends Node> result = xpath.selectNodes(this.metaset);
        BaseXPathTest.assertEquals((int)4, (int)result.size());
        BaseXPathTest.assertEquals((Object)a1.getQName(), (Object)((Attribute)result.get(0)).getQName());
        BaseXPathTest.assertEquals((String)a1.getValue(), (String)((Attribute)result.get(0)).getValue());
        BaseXPathTest.assertEquals((Object)a2.getQName(), (Object)((Attribute)result.get(1)).getQName());
        BaseXPathTest.assertEquals((String)a2.getValue(), (String)((Attribute)result.get(1)).getValue());
        BaseXPathTest.assertEquals((Object)a3.getQName(), (Object)((Attribute)result.get(2)).getQName());
        BaseXPathTest.assertEquals((String)a3.getValue(), (String)((Attribute)result.get(2)).getValue());
        BaseXPathTest.assertEquals((Object)a4.getQName(), (Object)((Attribute)result.get(3)).getQName());
        BaseXPathTest.assertEquals((String)a4.getValue(), (String)((Attribute)result.get(3)).getValue());
        this.metaset.elements().clear();
    }

    public void testMultipleAttributesOnElement() throws JaxenException {
        XPath xpath = DocumentHelper.createXPath("./descendant::x/@*");
        Metaset a = builder.newMetaset("a");
        Metaset b = builder.newMetaset("b");
        this.metaset.add(a);
        a.setParent(this.metaset);
        Metaset x1 = builder.newMetaset("x");
        a.add(x1);
        x1.setParent(a);
        a.add(b);
        b.setParent(a);
        Attribute a1 = builder.newAttribute("name1", "1");
        x1.add(a1);
        Attribute a2 = builder.newAttribute("name2", "2");
        x1.add(a2);
        Attribute a3 = builder.newAttribute("name3", "3");
        x1.add(a3);
        Attribute a4 = builder.newAttribute("name4", "4");
        x1.add(a4);
        List<? extends Node> result = xpath.selectNodes(this.metaset);
        BaseXPathTest.assertEquals((int)4, (int)result.size());
        BaseXPathTest.assertEquals((Object)a1.getQName(), (Object)((Attribute)result.get(3)).getQName());
        BaseXPathTest.assertEquals((String)a1.getValue(), (String)((Attribute)result.get(3)).getValue());
        BaseXPathTest.assertEquals((Object)a2.getQName(), (Object)((Attribute)result.get(2)).getQName());
        BaseXPathTest.assertEquals((String)a2.getValue(), (String)((Attribute)result.get(2)).getValue());
        BaseXPathTest.assertEquals((Object)a3.getQName(), (Object)((Attribute)result.get(1)).getQName());
        BaseXPathTest.assertEquals((String)a3.getValue(), (String)((Attribute)result.get(1)).getValue());
        BaseXPathTest.assertEquals((Object)a4.getQName(), (Object)((Attribute)result.get(0)).getQName());
        BaseXPathTest.assertEquals((String)a4.getValue(), (String)((Attribute)result.get(0)).getValue());
        this.metaset.elements().clear();
    }

    public void testXMLNamespaceAttributeOrderOnAncestorAxis() throws JaxenException {
        Metaset superroot = builder.newMetaset("superroot");
        this.metaset.add(superroot);
        superroot.setParent(this.metaset);
        Metaset root = builder.newMetaset("root");
        superroot.add(root);
        root.setParent(superroot);
        Attribute p0 = builder.newAttribute("http://www.w3.org/XML/1998/namespace", "id", "xml", "p0");
        superroot.add(p0);
        Attribute p1 = builder.newAttribute("http://www.w3.org/XML/1998/namespace", "id", "xml", "p1");
        root.add(p1);
        Metaset child = builder.newMetaset("child312");
        root.add(child);
        XPath xpath = DocumentHelper.createXPath("ancestor::*/@xml:*");
        List<? extends Node> result = xpath.selectNodes(child);
        BaseXPathTest.assertEquals((int)2, (int)result.size());
        BaseXPathTest.assertEquals((Object)p0.getQName(), (Object)((Attribute)result.get(0)).getQName());
        BaseXPathTest.assertEquals((String)p0.getValue(), (String)((Attribute)result.get(0)).getValue());
        BaseXPathTest.assertEquals((Object)p1.getQName(), (Object)((Attribute)result.get(1)).getQName());
        BaseXPathTest.assertEquals((String)p1.getValue(), (String)((Attribute)result.get(1)).getValue());
        this.metaset.elements().clear();
    }

    public void testDescendantAxisWithAttributesAndChildren() throws JaxenException {
        XPath xpath = DocumentHelper.createXPath(".//descendant::x/@* | .//descendant::x");
        Metaset a = builder.newMetaset("a");
        Metaset b = builder.newMetaset("b");
        this.metaset.add(a);
        a.setParent(this.metaset);
        Metaset x1 = builder.newMetaset("x");
        a.add(x1);
        x1.setParent(a);
        a.add(b);
        b.setParent(a);
        Metaset x2 = builder.newMetaset("x");
        Metaset x3 = builder.newMetaset("x");
        Metaset x4 = builder.newMetaset("x");
        a.add(x4);
        x4.setParent(a);
        b.add(x2);
        x2.setParent(b);
        b.add(x3);
        x3.setParent(b);
        Attribute a1 = builder.newAttribute("name", "1");
        x1.add(a1);
        Attribute a2 = builder.newAttribute("name", "2");
        x2.add(a2);
        Attribute a3 = builder.newAttribute("name", "3");
        x3.add(a3);
        Attribute a4 = builder.newAttribute("name", "4");
        x4.add(a4);
        List<? extends Node> result = xpath.selectNodes(this.metaset);
        BaseXPathTest.assertEquals((int)8, (int)result.size());
        BaseXPathTest.assertEquals((Object)x1, (Object)result.get(0));
        BaseXPathTest.assertEquals((String)a1.getValue(), (String)((Attribute)result.get(1)).getValue());
        BaseXPathTest.assertEquals((Object)a1.getQName(), (Object)((Attribute)result.get(1)).getQName());
        BaseXPathTest.assertEquals((Object)x2, (Object)result.get(2));
        BaseXPathTest.assertEquals((String)a2.getValue(), (String)((Attribute)result.get(3)).getValue());
        BaseXPathTest.assertEquals((Object)a2.getQName(), (Object)((Attribute)result.get(3)).getQName());
        BaseXPathTest.assertEquals((Object)x3, (Object)result.get(4));
        BaseXPathTest.assertEquals((String)a3.getValue(), (String)((Attribute)result.get(5)).getValue());
        BaseXPathTest.assertEquals((Object)a3.getQName(), (Object)((Attribute)result.get(5)).getQName());
        BaseXPathTest.assertEquals((Object)x4, (Object)result.get(6));
        BaseXPathTest.assertEquals((String)a4.getValue(), (String)((Attribute)result.get(7)).getValue());
        BaseXPathTest.assertEquals((Object)a4.getQName(), (Object)((Attribute)result.get(7)).getQName());
        this.metaset.elements().clear();
    }

    public void testAncestorAxisWithAttributes() throws JaxenException {
        XPath xpath = DocumentHelper.createXPath("ancestor::*/@*");
        Metaset a = builder.newMetaset("a");
        Metaset b = builder.newMetaset("b");
        this.metaset.add(a);
        a.setParent(this.metaset);
        a.add(b);
        b.setParent(a);
        Metaset x3 = builder.newMetaset("x");
        b.add(x3);
        x3.setParent(b);
        Attribute a1 = builder.newAttribute("name", "1");
        a.add(a1);
        Attribute a2 = builder.newAttribute("name", "2");
        b.add(a2);
        Attribute a3 = builder.newAttribute("name", "3");
        x3.add(a3);
        List<? extends Node> result = xpath.selectNodes(x3);
        BaseXPathTest.assertEquals((int)2, (int)result.size());
        BaseXPathTest.assertEquals((String)a1.getValue(), (String)((Attribute)result.get(0)).getValue());
        BaseXPathTest.assertEquals((Object)a1.getQName(), (Object)((Attribute)result.get(0)).getQName());
        BaseXPathTest.assertEquals((String)a2.getValue(), (String)((Attribute)result.get(1)).getValue());
        BaseXPathTest.assertEquals((Object)a2.getQName(), (Object)((Attribute)result.get(1)).getQName());
        this.metaset.elements().clear();
    }

    public void testDescendantOrSelfAxis() throws JaxenException {
        XPath xpath = DocumentHelper.createXPath(".//descendant-or-self::x");
        Metaset a = builder.newMetaset("a");
        Metaset b = builder.newMetaset("b");
        this.metaset.add(a);
        a.setParent(this.metaset);
        Metaset x1 = builder.newMetaset("x");
        a.add(x1);
        x1.setParent(a);
        a.add(b);
        b.setParent(a);
        Metaset x2 = builder.newMetaset("x");
        Metaset x3 = builder.newMetaset("x");
        Metaset x4 = builder.newMetaset("x");
        a.add(x4);
        x4.setParent(a);
        b.add(x2);
        x2.setParent(b);
        b.add(x3);
        x3.setParent(b);
        List<? extends Node> result = xpath.selectNodes(this.metaset);
        BaseXPathTest.assertEquals((int)4, (int)result.size());
        BaseXPathTest.assertEquals((Object)x1, (Object)result.get(0));
        BaseXPathTest.assertEquals((Object)x2, (Object)result.get(1));
        BaseXPathTest.assertEquals((Object)x3, (Object)result.get(2));
        BaseXPathTest.assertEquals((Object)x4, (Object)result.get(3));
        this.metaset.elements().clear();
    }

    public void testDuplicateNodes() throws JaxenException {
        XPath xpath = DocumentHelper.createXPath(".//x | .//*");
        Metaset a = builder.newMetaset("a");
        Metaset b = builder.newMetaset("b");
        this.metaset.add(a);
        a.setParent(this.metaset);
        Metaset x1 = builder.newMetaset("x");
        a.add(x1);
        x1.setParent(a);
        a.add(b);
        b.setParent(a);
        Metaset x2 = builder.newMetaset("x");
        Metaset x3 = builder.newMetaset("x");
        Metaset x4 = builder.newMetaset("x");
        a.add(x4);
        x4.setParent(a);
        b.add(x2);
        x2.setParent(b);
        b.add(x3);
        x3.setParent(b);
        List<? extends Node> result = xpath.selectNodes(this.metaset);
        BaseXPathTest.assertEquals((int)6, (int)result.size());
        this.metaset.elements().clear();
    }

    public void testJaxen107() throws JaxenException {
        Metaset a = builder.newMetaset("http://www.a.com/", "foo", "a");
        this.metaset.add(a);
        a.setParent(this.metaset);
        Metaset b = builder.newMetaset("http://www.b.com/", "bar", "b");
        a.add(b);
        b.setParent(a);
        XPath xpath = DocumentHelper.createXPath(".//a:foo/b:bar");
        SimpleNamespaceContext context1 = new SimpleNamespaceContext();
        context1.addNamespace("a", "http://www.a.com/");
        context1.addNamespace("b", "http://www.b.com/");
        xpath.setNamespaceContext((NamespaceContext)context1);
        List<? extends Node> result = xpath.selectNodes(this.metaset);
        BaseXPathTest.assertEquals((int)1, (int)result.size());
        BaseXPathTest.assertEquals((Object)b, (Object)result.get(0));
        this.metaset.elements().clear();
    }

    public void testJaxen107FromFile() throws JaxenException, SAXException, IOException, MetasetParsingException {
        InputStream in = BaseXPathTest.class.getClassLoader().getResourceAsStream("textFile/xpath/testNamespaces.xml");
        Metaset root = MetasetParserFactory.getStAXParser().parse(in);
        this.metaset.add(root);
        XPath xpath = DocumentHelper.createXPath(".//Template/Application2");
        List<? extends Node> result = xpath.selectNodes(this.metaset);
        BaseXPathTest.assertEquals((int)1, (int)result.size());
        this.metaset.elements().clear();
    }
}

