/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.impl.xpath;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.act.xservices.rt.metaset.MetasetBuilder;
import org.act.xservices.rt.metaset.MetasetParserFactory;
import org.act.xservices.rt.metaset.exception.MetasetParsingException;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.impl.xpath.MetasetFilterByXPath;
import org.act.xservices.rt.xom.xpath.DefaultXPath;
import org.jaxen.JaxenException;
import org.jaxen.saxpath.SAXPathException;

public class MetasetXPathTest
extends TestCase {
    private static final String BASIC_XML = "textFile/xpath/basic.xml";
    private Metaset metaset;
    private MetasetBuilder builder;

    public MetasetXPathTest(String name) {
        super(name);
    }

    public void setUp() {
        this.builder = new MetasetBuilder();
        this.metaset = this.builder.newMetaset();
    }

    public void testConstruction() throws JaxenException {
        DefaultXPath xpath = new DefaultXPath("./foo/bar/baz");
    }

    public void testConstructionWithNamespacePrefix() throws JaxenException {
        DefaultXPath xpath = new DefaultXPath("./p:foo/p:bar/a:baz");
    }

    public void testMetasetSelection() throws MetasetParsingException, SAXPathException {
        DefaultXPath xpath = new DefaultXPath("./foo/bar/baz");
        InputStream in = MetasetFilterByXPath.class.getClassLoader().getResourceAsStream(BASIC_XML);
        Metaset root = MetasetParserFactory.getStAXParser().parse(in);
        this.metaset.add(root);
        root.setParent(this.metaset);
        List results = xpath.selectNodes(this.metaset);
        MetasetXPathTest.assertEquals((int)3, (int)results.size());
        Iterator iter = results.iterator();
        MetasetXPathTest.assertEquals((String)"baz", (String)((Metaset)iter.next()).getName());
        MetasetXPathTest.assertEquals((String)"baz", (String)((Metaset)iter.next()).getName());
        MetasetXPathTest.assertEquals((String)"baz", (String)((Metaset)iter.next()).getName());
        MetasetXPathTest.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        this.metaset.elements().clear();
    }
}

