/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.io;

import java.io.StringWriter;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.dom.DOMDocument;
import org.act.xservices.rt.xom.io.DOMWriter;
import org.act.xservices.rt.xom.io.OutputFormat;
import org.act.xservices.rt.xom.io.XMLWriter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMWriterTest
extends AbstractTestCase {
    public static void main(String[] args) {
        TestRunner.run(DOMWriterTest.class);
    }

    public void testNamespaceBug() throws Exception {
        Document doc = this.getDocument("xml/namespaces.xml");
        DOMWriter writer = new DOMWriter(DOMDocument.class);
        org.w3c.dom.Document result = writer.write(doc);
        NamedNodeMap atts = result.getDocumentElement().getAttributes();
        DOMWriterTest.assertEquals((int)4, (int)atts.getLength());
        XMLWriter wr = new XMLWriter();
        wr.setOutputStream(System.out);
        wr.write((Document)((Object)result));
    }

    public void testBug905745() throws Exception {
        Document doc = this.getDocument("xml/namespaces.xml");
        DOMWriter writer = new DOMWriter();
        org.w3c.dom.Document result = writer.write(doc);
        NamedNodeMap atts = result.getDocumentElement().getAttributes();
        Node versionAttr = atts.getNamedItem("version");
        DOMWriterTest.assertNotNull((Object)versionAttr);
        DOMWriterTest.assertNotNull((Object)versionAttr.getLocalName());
        DOMWriterTest.assertEquals((String)"version", (String)versionAttr.getLocalName());
        DOMWriterTest.assertEquals((String)"version", (String)versionAttr.getNodeName());
    }

    public void testBug926752() throws Exception {
        Document doc = this.getDocument("xml/test/defaultNamespace.xml");
        DOMWriter writer = new DOMWriter(DOMDocument.class);
        org.w3c.dom.Document result = writer.write(doc);
        NamedNodeMap atts = result.getDocumentElement().getAttributes();
        DOMWriterTest.assertEquals((int)1, (int)atts.getLength());
        OutputFormat format = OutputFormat.createCompactFormat();
        format.setSuppressDeclaration(true);
        XMLWriter wr = new XMLWriter(format);
        StringWriter strWriter = new StringWriter();
        wr.setWriter(strWriter);
        wr.write((Document)((Object)result));
        DOMWriterTest.assertEquals((String)"<a xmlns=\"dummyNamespace\"><b><c>Hello</c></b></a>", (String)strWriter.toString());
    }
}

