/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentType;
import org.act.xservices.rt.xom.dtd.AttributeDecl;
import org.act.xservices.rt.xom.dtd.Declaration;
import org.act.xservices.rt.xom.dtd.ElementDecl;
import org.act.xservices.rt.xom.dtd.ExternalEntityDecl;
import org.act.xservices.rt.xom.dtd.InternalEntityDecl;
import org.act.xservices.rt.xom.io.SAXReader;
import org.act.xservices.rt.xom.tree.DefaultDocumentType;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DTDTest
extends AbstractTestCase {
    private static final String XML_INTERNAL_FILE = "xml/dtd/internal.xml";
    private static final String XML_EXTERNAL_FILE = "xml/dtd/external.xml";
    private static final String XML_MIXED = "xml/dtd/mixed.xml";
    private static final String DTD_FILE = "xml/dtd/sample.dtd";
    protected static final String DTD_PUBLICID = "-//dom4j//DTD sample";
    protected static final String DTD_SYSTEM_ID = "sample.dtd";

    public static void main(String[] args) {
        TestRunner.run(DTDTest.class);
    }

    public void testInternalDTDSubset() throws Exception {
        DefaultDocumentType expected = new DefaultDocumentType();
        expected.setElementName("greeting");
        expected.setInternalDeclarations(this.getInternalDeclarations());
        try {
            this.assertSameDocumentType(expected, this.readDocument(XML_INTERNAL_FILE, true, false).getDocType());
        }
        catch (AssertionFailedError ex) {
            throw ex;
        }
        catch (Throwable t) {
            DTDTest.fail((String)("Not expecting: " + t));
        }
    }

    public void testExternalDTDSubset() {
        DefaultDocumentType expected = new DefaultDocumentType("another-greeting", null, DTD_SYSTEM_ID);
        expected.setExternalDeclarations(this.getExternalDeclarations());
        try {
            this.assertSameDocumentType(expected, this.readDocument(XML_EXTERNAL_FILE, false, true).getDocType());
        }
        catch (AssertionFailedError ex) {
            throw ex;
        }
        catch (Throwable t) {
            DTDTest.fail((String)("Not expecting: " + t));
        }
    }

    public void testMixedDTDSubset() {
        DefaultDocumentType expected = new DefaultDocumentType("another-greeting", null, DTD_SYSTEM_ID);
        expected.setInternalDeclarations(this.getInternalDeclarations());
        expected.setExternalDeclarations(this.getExternalDeclarations());
        try {
            this.assertSameDocumentType(expected, this.readDocument(XML_MIXED, true, true).getDocType());
        }
        catch (AssertionFailedError ex) {
            throw ex;
        }
        catch (Throwable t) {
            DTDTest.fail((String)("Not expecting: " + t));
        }
    }

    protected List getInternalDeclarations() {
        ArrayList<Declaration> decls = new ArrayList<Declaration>();
        decls.add(new ElementDecl("greeting", "(#PCDATA)"));
        decls.add(new AttributeDecl("greeting", "foo", "ID", "#IMPLIED", null));
        decls.add(new InternalEntityDecl("%boolean", "( true | false )"));
        return decls;
    }

    protected List getExternalDeclarations() {
        ArrayList<ElementDecl> decls = new ArrayList<ElementDecl>();
        decls.add(new ElementDecl("another-greeting", "(#PCDATA)"));
        return decls;
    }

    protected void assertSameDocumentType(DocumentType expected, DocumentType actual) {
        if (expected == null) {
            if (actual == null) {
                return;
            }
            DTDTest.fail((String)"Not expecting DOCTYPE.");
        } else {
            if (actual == null) {
                DTDTest.fail((String)"Expecting DOCTYPE");
            }
            this.log("Expected DocumentType:\n" + expected.toString());
            this.log("Actual DocumentType:\n" + actual.toString());
            this.assertSameDTDSubset("Internal", expected.getInternalDeclarations(), actual.getInternalDeclarations());
            this.assertSameDTDSubset("External", expected.getExternalDeclarations(), actual.getExternalDeclarations());
        }
    }

    protected void assertSameDTDSubset(String txt, List expected, List actual) {
        if (expected == null) {
            if (actual == null) {
                return;
            }
            DTDTest.fail((String)("Not expecting " + txt + " DTD subset."));
        } else {
            if (actual == null) {
                DTDTest.fail((String)("Expecting " + txt + " DTD subset."));
            }
            DTDTest.assertEquals((String)(String.valueOf(txt) + " DTD subset has correct #of declarations" + ": expected=[" + expected.toString() + "]" + ", actual=[" + actual.toString() + "]"), (int)expected.size(), (int)actual.size());
            Iterator itr1 = expected.iterator();
            Iterator itr2 = actual.iterator();
            while (itr1.hasNext()) {
                Object obj1 = itr1.next();
                Object obj2 = itr2.next();
                DTDTest.assertEquals((String)(String.valueOf(txt) + " DTD subset: Same type of declaration"), (String)obj1.getClass().getName(), (String)obj2.getClass().getName());
                if (obj1 instanceof AttributeDecl) {
                    this.assertSameDecl((AttributeDecl)obj1, (AttributeDecl)obj2);
                    continue;
                }
                if (obj1 instanceof ElementDecl) {
                    this.assertSameDecl((ElementDecl)obj1, (ElementDecl)obj2);
                    continue;
                }
                if (obj1 instanceof InternalEntityDecl) {
                    this.assertSameDecl((InternalEntityDecl)obj1, (InternalEntityDecl)obj2);
                    continue;
                }
                if (obj1 instanceof ExternalEntityDecl) {
                    this.assertSameDecl((ExternalEntityDecl)obj1, (ExternalEntityDecl)obj2);
                    continue;
                }
                throw new AssertionError((Object)("Unexpected declaration type: " + obj1.getClass()));
            }
        }
    }

    public void assertSameDecl(AttributeDecl expected, AttributeDecl actual) {
        DTDTest.assertEquals((String)"attributeName is correct", (String)expected.getAttributeName(), (String)actual.getAttributeName());
        DTDTest.assertEquals((String)"elementName is correct", (String)expected.getElementName(), (String)actual.getElementName());
        DTDTest.assertEquals((String)"type is correct", (String)expected.getType(), (String)actual.getType());
        DTDTest.assertEquals((String)"value is not correct", (String)expected.getValue(), (String)actual.getValue());
        DTDTest.assertEquals((String)"valueDefault is correct", (String)expected.getValueDefault(), (String)actual.getValueDefault());
        DTDTest.assertEquals((String)"toString() is correct", (String)expected.toString(), (String)actual.toString());
    }

    protected void assertSameDecl(ElementDecl expected, ElementDecl actual) {
        DTDTest.assertEquals((String)"name is correct", (String)expected.getName(), (String)actual.getName());
        DTDTest.assertEquals((String)"model is not correct", (String)expected.getModel(), (String)actual.getModel());
        DTDTest.assertEquals((String)"toString() is correct", (String)expected.toString(), (String)actual.toString());
    }

    protected void assertSameDecl(InternalEntityDecl expected, InternalEntityDecl actual) {
        DTDTest.assertEquals((String)"name is correct", (String)expected.getName(), (String)actual.getName());
        DTDTest.assertEquals((String)"value is not correct", (String)expected.getValue(), (String)actual.getValue());
        DTDTest.assertEquals((String)"toString() is correct", (String)expected.toString(), (String)actual.toString());
    }

    protected void assertSameDecl(ExternalEntityDecl expected, ExternalEntityDecl actual) {
        DTDTest.assertEquals((String)"name is correct", (String)expected.getName(), (String)actual.getName());
        DTDTest.assertEquals((String)"publicID is correct", (String)expected.getPublicID(), (String)actual.getPublicID());
        DTDTest.assertEquals((String)"systemID is correct", (String)expected.getSystemID(), (String)actual.getSystemID());
        DTDTest.assertEquals((String)"toString() is correct", (String)expected.toString(), (String)actual.toString());
    }

    protected Document readDocument(String resourceName, boolean includeInternal, boolean includeExternal) throws Exception {
        SAXReader reader = new SAXReader();
        reader.setIncludeInternalDTDDeclarations(includeInternal);
        reader.setIncludeExternalDTDDeclarations(includeExternal);
        reader.setEntityResolver(new MyEntityResolver(DTD_FILE, DTD_PUBLICID, DTD_SYSTEM_ID));
        return this.getDocument(resourceName, reader);
    }

    protected static class MyEntityResolver
    implements EntityResolver {
        private String resourceName;
        private String pubId;
        private String sysId;

        public MyEntityResolver(String localResourceName, String publicId, String systemId) {
            this.resourceName = localResourceName;
            this.sysId = systemId;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (this.pubId != null && this.pubId.equals(publicId)) {
                return new InputSource(this.getInputStream(this.resourceName));
            }
            if (this.sysId.equals(systemId)) {
                return new InputSource(this.getInputStream(this.resourceName));
            }
            return null;
        }

        protected InputStream getInputStream(String localResourceName) throws IOException {
            FileInputStream is = new FileInputStream(localResourceName);
            return is;
        }
    }
}

