/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.io;

import org.act.xservices.rt.xom.ElementHandler;
import org.act.xservices.rt.xom.ElementPath;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.io.DispatchHandler;

public class ElementStack
implements ElementPath {
    protected Metaset[] stack;
    protected int lastElementIndex = -1;
    private DispatchHandler handler = null;

    public ElementStack() {
        this(50);
    }

    public ElementStack(int defaultCapacity) {
        this.stack = new Metaset[defaultCapacity];
    }

    public void setDispatchHandler(DispatchHandler dispatchHandler) {
        this.handler = dispatchHandler;
    }

    public DispatchHandler getDispatchHandler() {
        return this.handler;
    }

    public void clear() {
        this.lastElementIndex = -1;
    }

    public Metaset peekElement() {
        if (this.lastElementIndex < 0) {
            return null;
        }
        return this.stack[this.lastElementIndex];
    }

    public Metaset popElement() {
        if (this.lastElementIndex < 0) {
            return null;
        }
        return this.stack[this.lastElementIndex--];
    }

    public void pushElement(Metaset element) {
        int length = this.stack.length;
        if (++this.lastElementIndex >= length) {
            this.reallocate(length * 2);
        }
        this.stack[this.lastElementIndex] = element;
    }

    protected void reallocate(int size) {
        Metaset[] oldStack = this.stack;
        this.stack = new Metaset[size];
        System.arraycopy(oldStack, 0, this.stack, 0, oldStack.length);
    }

    public int size() {
        return this.lastElementIndex + 1;
    }

    public Metaset getElement(int depth) {
        Metaset element;
        try {
            element = this.stack[depth];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            element = null;
        }
        return element;
    }

    public String getPath() {
        if (this.handler == null) {
            this.setDispatchHandler(new DispatchHandler());
        }
        return this.handler.getPath();
    }

    public Metaset getCurrent() {
        return this.peekElement();
    }

    public void addHandler(String path, ElementHandler elementHandler) {
        this.handler.addHandler(this.getHandlerPath(path), elementHandler);
    }

    public void removeHandler(String path) {
        this.handler.removeHandler(this.getHandlerPath(path));
    }

    public boolean containsHandler(String path) {
        return this.handler.containsHandler(path);
    }

    private String getHandlerPath(String path) {
        if (this.handler == null) {
            this.setDispatchHandler(new DispatchHandler());
        }
        String handlerPath = path.startsWith("/") ? path : (this.getPath().equals("/") ? String.valueOf(this.getPath()) + path : String.valueOf(this.getPath()) + "/" + path);
        return handlerPath;
    }
}

