/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.io;

import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.ElementHandler;
import org.act.xservices.rt.xom.ElementPath;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.io.ElementModifier;
import org.act.xservices.rt.xom.io.ElementStack;
import org.act.xservices.rt.xom.io.SAXModifyException;

class SAXModifyElementHandler
implements ElementHandler {
    private ElementModifier elemModifier;
    private Metaset modifiedElement;

    public SAXModifyElementHandler(ElementModifier elemModifier) {
        this.elemModifier = elemModifier;
    }

    public void onStart(ElementPath elementPath) {
        this.modifiedElement = elementPath.getCurrent();
    }

    public void onEnd(ElementPath elementPath) {
        try {
            Metaset clonedElem;
            Metaset origElement = elementPath.getCurrent();
            Metaset currentParent = origElement.getParent();
            if (currentParent != null) {
                clonedElem = (Metaset)origElement.clone();
                this.modifiedElement = this.elemModifier.modifyElement(clonedElem);
                if (this.modifiedElement != null) {
                    this.modifiedElement.setParent(origElement.getParent());
                    this.modifiedElement.setDocument(origElement.getDocument());
                    int contentIndex = currentParent.indexOf(origElement);
                    currentParent.content().set(contentIndex, this.modifiedElement);
                }
                origElement.detach();
            } else if (origElement.isRootElement()) {
                clonedElem = (Metaset)origElement.clone();
                this.modifiedElement = this.elemModifier.modifyElement(clonedElem);
                if (this.modifiedElement != null) {
                    this.modifiedElement.setDocument(origElement.getDocument());
                    Document doc = origElement.getDocument();
                    doc.setRootElement(this.modifiedElement);
                }
                origElement.detach();
            }
            if (elementPath instanceof ElementStack) {
                ElementStack elementStack = (ElementStack)elementPath;
                elementStack.popElement();
                elementStack.pushElement(this.modifiedElement);
            }
        }
        catch (Exception ex) {
            throw new SAXModifyException(ex);
        }
    }

    protected Metaset getModifiedElement() {
        return this.modifiedElement;
    }
}

