/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentHelper;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.io.OutputFormat;
import org.act.xservices.rt.xom.io.SAXReader;
import org.act.xservices.rt.xom.io.XMLWriter;

public class SAXReaderTest
extends AbstractTestCase {
    public static void main(String[] args) {
        TestRunner.run(SAXReaderTest.class);
    }

    public void testReadFile() throws Exception {
        File file = this.getFile("xml/#.xml");
        new SAXReader().read(file);
    }

    public void testEncoding() throws Exception {
        String xml = "<?xml version='1.0' encoding='ISO-8859-1'?><root/>";
        SAXReader reader = new SAXReader();
        reader.setEncoding("ISO-8859-1");
        Document doc = reader.read(new StringReader(xml));
        SAXReaderTest.assertEquals((String)"encoding incorrect", (String)"ISO-8859-1", (String)doc.getXMLEncoding());
    }

    public void testRussian() throws Exception {
        Document doc = this.getDocument("xml/russArticle.xml");
        SAXReaderTest.assertEquals((String)"encoding not correct", (String)"koi8-r", (String)doc.getXMLEncoding());
        Metaset el = doc.getRootElement();
        StringWriter writer = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter(writer);
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("koi8-r");
        xmlWriter.write(doc);
        this.log(writer.toString());
    }

    public void testRussian2() throws Exception {
        Document doc = this.getDocument("xml/russArticle.xml");
        XMLWriter xmlWriter = new XMLWriter(new OutputFormat("", false, "koi8-r"));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        xmlWriter.setOutputStream(out);
        xmlWriter.write(doc);
        xmlWriter.flush();
        xmlWriter.close();
        this.log(out.toString());
    }

    public void testBug833765() throws Exception {
        SAXReader reader = new SAXReader();
        reader.setIncludeExternalDTDDeclarations(true);
        this.getDocument("xml/dtd/external.xml", reader);
    }

    public void testBug527062() throws Exception {
        Document doc = this.getDocument("xml/test/test.xml");
        List<? extends Node> l = doc.selectNodes("//broked/junk");
        int i = 0;
        while (i < l.size()) {
            System.out.println("Found node: " + ((Metaset)l.get(i)).getStringValue());
            ++i;
        }
        SAXReaderTest.assertEquals((String)"hi there", (String)((Metaset)l.get(0)).getStringValue());
        SAXReaderTest.assertEquals((String)"hello world", (String)((Metaset)l.get(1)).getStringValue());
    }

    public void testEscapedComment() throws Exception {
        String txt = "<eg>&lt;!-- &lt;head> &amp; &lt;body> --&gt;</eg>";
        Document doc = DocumentHelper.parseText(txt);
        Metaset eg = doc.getRootElement();
        System.out.println(doc.asXML());
        SAXReaderTest.assertEquals((String)"<!-- <head> & <body> -->", (String)eg.getText());
    }
}

