/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.io;

import java.io.StringReader;
import java.io.StringWriter;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.io.OutputFormat;
import org.act.xservices.rt.xom.io.SAXReader;
import org.act.xservices.rt.xom.io.XMLWriter;

public class WriteUnmergedTextTest
extends AbstractTestCase {
    protected static final boolean VERBOSE = true;
    private String inputText = "<?xml version = \"1.0\"?><TestEscapedEntities><TEXT>Test using &lt; &amp; &gt;</TEXT></TestEscapedEntities>";

    public static void main(String[] args) {
        TestRunner.run(WriteUnmergedTextTest.class);
    }

    public String readwriteText(OutputFormat outFormat, boolean mergeAdjacentText) throws Exception {
        StringWriter out = new StringWriter();
        StringReader in = new StringReader(this.inputText);
        SAXReader reader = new SAXReader();
        reader.setMergeAdjacentText(mergeAdjacentText);
        Document document = reader.read(in);
        XMLWriter writer = outFormat == null ? new XMLWriter(out) : new XMLWriter(out, outFormat);
        writer.write(document);
        writer.close();
        String outText = out.toString();
        return outText;
    }

    public void testWithoutFormatNonMerged() throws Exception {
        String outText = this.readwriteText(null, false);
        this.log("Text output is [");
        this.log(outText);
        this.log("]. Done");
        WriteUnmergedTextTest.assertTrue((String)"Output text contains \"&amp;\"", (outText.lastIndexOf("&amp;") >= 0 ? 1 : 0) != 0);
        WriteUnmergedTextTest.assertTrue((String)"Output text contains \"&lt;\"", (outText.lastIndexOf("&lt;") >= 0 ? 1 : 0) != 0);
    }

    public void testWithCompactFormatNonMerged() throws Exception {
        String outText = this.readwriteText(OutputFormat.createCompactFormat(), false);
        this.log("Text output is [");
        this.log(outText);
        this.log("]. Done");
        WriteUnmergedTextTest.assertTrue((String)"Output text contains \"&amp;\"", (outText.lastIndexOf("&amp;") >= 0 ? 1 : 0) != 0);
        WriteUnmergedTextTest.assertTrue((String)"Output text contains \"&lt;\"", (outText.lastIndexOf("&lt;") >= 0 ? 1 : 0) != 0);
    }

    public void testWithPrettyPrintFormatNonMerged() throws Exception {
        String outText = this.readwriteText(OutputFormat.createPrettyPrint(), false);
        this.log("Text output is [");
        this.log(outText);
        this.log("]. Done");
        WriteUnmergedTextTest.assertTrue((String)"Output text contains \"&amp;\"", (outText.lastIndexOf("&amp;") >= 0 ? 1 : 0) != 0);
        WriteUnmergedTextTest.assertTrue((String)"Output text contains \"&lt;\"", (outText.lastIndexOf("&lt;") >= 0 ? 1 : 0) != 0);
    }

    public void testWithoutFormatMerged() throws Exception {
        String outText = this.readwriteText(null, true);
        this.log("Text output is [");
        this.log(outText);
        this.log("]. Done");
        WriteUnmergedTextTest.assertTrue((String)"Output text contains \"&amp;\"", (outText.lastIndexOf("&amp;") >= 0 ? 1 : 0) != 0);
        WriteUnmergedTextTest.assertTrue((String)"Output text contains \"&lt;\"", (outText.lastIndexOf("&lt;") >= 0 ? 1 : 0) != 0);
    }

    public void testWithCompactFormatMerged() throws Exception {
        String out = this.readwriteText(OutputFormat.createCompactFormat(), true);
        this.log("Text output is [");
        this.log(out);
        this.log("]. Done");
        WriteUnmergedTextTest.assertTrue((String)"Output text contains \"&amp;\"", (out.lastIndexOf("&amp;") >= 0 ? 1 : 0) != 0);
        WriteUnmergedTextTest.assertTrue((String)"Output text contains \"&lt;\"", (out.lastIndexOf("&lt;") >= 0 ? 1 : 0) != 0);
    }

    public void testWithPrettyPrintFormatMerged() throws Exception {
        String outText = this.readwriteText(OutputFormat.createPrettyPrint(), true);
        this.log("Text output is [");
        this.log(outText);
        this.log("]. Done");
        WriteUnmergedTextTest.assertTrue((String)"Output text contains \"&amp;\"", (outText.lastIndexOf("&amp;") >= 0 ? 1 : 0) != 0);
        WriteUnmergedTextTest.assertTrue((String)"Output text contains \"&lt;\"", (outText.lastIndexOf("&lt;") >= 0 ? 1 : 0) != 0);
    }
}

