/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.query;

import junit.framework.TestCase;
import org.act.xservices.rt.metaset.exception.ElementExpressionException;
import org.act.xservices.rt.metaset.query.ElementExpression;

public class ElementExpressionTest
extends TestCase {
    public ElementExpressionTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testParseForNSPrefix() {
        try {
            ElementExpression eleExp = new ElementExpression("act:book@actAttr:name='java'");
            ElementExpressionTest.assertEquals((String)"book", (String)eleExp.getElementQName().getName());
            ElementExpressionTest.assertEquals((String)"act", (String)eleExp.getElementQName().getNamespacePrefix());
            ElementExpressionTest.assertTrue((boolean)eleExp.getElementQName().getNamespaceURI().equals(""));
            ElementExpressionTest.assertEquals((int)1, (int)eleExp.getAttrList().size());
            ElementExpressionTest.assertEquals((String)"actAttr", (String)eleExp.getAttrList().get(0).getQName().getNamespacePrefix());
            ElementExpressionTest.assertEquals((String)"name", (String)eleExp.getAttrList().get(0).getQName().getName());
            ElementExpressionTest.assertTrue((boolean)eleExp.getAttrList().get(0).getQName().getNamespaceURI().equals(""));
            ElementExpressionTest.assertEquals((String)"java", (String)eleExp.getAttrList().get(0).getValue());
        }
        catch (ElementExpressionException e) {
            ElementExpressionTest.fail((String)"Error");
        }
    }

    public void testParseForNSURI() {
        try {
            ElementExpression eleExp = new ElementExpression("{http://act.buaa.edu.cn}book@{http://xiao.org}name\u4e2d\u56fd='java'");
            ElementExpressionTest.assertEquals((String)"book", (String)eleExp.getElementQName().getName());
            ElementExpressionTest.assertEquals((String)"http://act.buaa.edu.cn", (String)eleExp.getElementQName().getNamespaceURI());
            ElementExpressionTest.assertEquals((int)1, (int)eleExp.getAttrList().size());
            ElementExpressionTest.assertEquals((String)"http://xiao.org", (String)eleExp.getAttrList().get(0).getQName().getNamespaceURI());
            ElementExpressionTest.assertEquals((String)"name\u4e2d\u56fd", (String)eleExp.getAttrList().get(0).getQName().getName());
            ElementExpressionTest.assertEquals((String)"java", (String)eleExp.getAttrList().get(0).getValue());
        }
        catch (ElementExpressionException e) {
            ElementExpressionTest.fail((String)"Error");
        }
    }

    public void testParseForNSURI1() {
        try {
            ElementExpression eleExp = new ElementExpression("{http://act.buaa.edu.cn}book@actAttr:name='java'");
            ElementExpressionTest.assertEquals((String)"book", (String)eleExp.getElementQName().getName());
            ElementExpressionTest.assertEquals((String)"http://act.buaa.edu.cn", (String)eleExp.getElementQName().getNamespaceURI());
            ElementExpressionTest.assertEquals((int)1, (int)eleExp.getAttrList().size());
            ElementExpressionTest.assertEquals((String)"actAttr", (String)eleExp.getAttrList().get(0).getQName().getNamespacePrefix());
            ElementExpressionTest.assertEquals((String)"name", (String)eleExp.getAttrList().get(0).getQName().getName());
            ElementExpressionTest.assertTrue((boolean)eleExp.getAttrList().get(0).getQName().getNamespaceURI().equals(""));
            ElementExpressionTest.assertEquals((String)"java", (String)eleExp.getAttrList().get(0).getValue());
        }
        catch (ElementExpressionException e) {
            ElementExpressionTest.fail((String)"Error");
        }
    }

    public void testParse() {
        try {
            ElementExpression eleExp = new ElementExpression(".");
            ElementExpressionTest.assertEquals((String)".", (String)eleExp.getElementQName().getName());
        }
        catch (ElementExpressionException e) {
            ElementExpressionTest.fail((String)"Error");
        }
    }

    public void testParseForException() {
        try {
            new ElementExpression("{}book@actAttr:name='java'");
            ElementExpressionTest.fail((String)"should have thrown an exception !");
        }
        catch (ElementExpressionException e) {
            ElementExpressionTest.assertTrue((boolean)true);
        }
    }

    public void testParseForException1() {
        try {
            new ElementExpression("{book@:name='java'");
            ElementExpressionTest.fail((String)"should have thrown an exception !");
        }
        catch (ElementExpressionException e) {
            ElementExpressionTest.assertTrue((boolean)true);
        }
    }

    public void testParseForException2() {
        try {
            new ElementExpression("{:::}book@actAttr:='java'");
            ElementExpressionTest.fail((String)"should have thrown an exception !");
        }
        catch (ElementExpressionException e) {
            ElementExpressionTest.assertTrue((boolean)true);
        }
    }

    public void testParseForException3() {
        try {
            new ElementExpression("{:::}book@actAttr:name'java'");
            ElementExpressionTest.fail((String)"should have thrown an exception !");
        }
        catch (ElementExpressionException e) {
            ElementExpressionTest.assertTrue((boolean)true);
        }
    }
}

