/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.rule;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.act.xservices.rt.xom.Attribute;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.NodeType;
import org.act.xservices.rt.xom.rule.Action;
import org.act.xservices.rt.xom.rule.Rule;
import org.act.xservices.rt.xom.rule.RuleSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mode {
    private EnumMap<NodeType, RuleSet> ruleSets = new EnumMap(NodeType.class);
    private Map<String, RuleSet> elementNameRuleSets;
    private Map<String, RuleSet> attributeNameRuleSets;

    public void fireRule(Node node) throws Exception {
        Action action;
        Rule rule;
        if (node != null && (rule = this.getMatchingRule(node)) != null && (action = rule.getAction()) != null) {
            action.run(node);
        }
    }

    public void applyTemplates(Metaset element) throws Exception {
        int i = 0;
        int size = element.attributeCount();
        while (i < size) {
            Attribute attribute = element.attribute(i);
            this.fireRule(attribute);
            ++i;
        }
        i = 0;
        size = element.nodeCount();
        while (i < size) {
            Node node = element.node(i);
            this.fireRule(node);
            ++i;
        }
    }

    public void applyTemplates(Document document) throws Exception {
        int i = 0;
        int size = document.nodeCount();
        while (i < size) {
            Node node = document.node(i);
            this.fireRule(node);
            ++i;
        }
    }

    public void addRule(Rule rule) {
        NodeType matchType = rule.getMatchType();
        String name = rule.getMatchesNodeName();
        if (name != null) {
            switch (matchType) {
                case ELEMENT_NODE: {
                    this.elementNameRuleSets = this.addToNameMap(this.elementNameRuleSets, name, rule);
                    break;
                }
                case ATTRIBUTE_NODE: {
                    this.attributeNameRuleSets = this.addToNameMap(this.attributeNameRuleSets, name, rule);
                }
            }
        }
        if (matchType == NodeType.ANY_NODE) {
            for (RuleSet ruleSet : this.ruleSets.values()) {
                if (ruleSet == null) continue;
                ruleSet.addRule(rule);
            }
        }
        this.getRuleSet(matchType).addRule(rule);
    }

    public void removeRule(Rule rule) {
        NodeType matchType = rule.getMatchType();
        String name = rule.getMatchesNodeName();
        if (name != null) {
            switch (matchType) {
                case ELEMENT_NODE: {
                    this.removeFromNameMap(this.elementNameRuleSets, name, rule);
                    break;
                }
                case ATTRIBUTE_NODE: {
                    this.removeFromNameMap(this.attributeNameRuleSets, name, rule);
                }
            }
        }
        this.getRuleSet(matchType).removeRule(rule);
        if (matchType == NodeType.ANY_NODE) {
            this.getRuleSet(NodeType.ANY_NODE).removeRule(rule);
        }
    }

    public Rule getMatchingRule(Node node) {
        RuleSet ruleSet;
        NodeType matchType = node.getNodeTypeEnum();
        switch (matchType) {
            case ELEMENT_NODE: {
                Rule answer;
                String name;
                if (this.elementNameRuleSets == null || (ruleSet = this.elementNameRuleSets.get(name = node.getName())) == null || (answer = ruleSet.getMatchingRule(node)) == null) break;
                return answer;
            }
            case ATTRIBUTE_NODE: {
                Rule answer;
                String name;
                if (this.attributeNameRuleSets == null || (ruleSet = this.attributeNameRuleSets.get(name = node.getName())) == null || (answer = ruleSet.getMatchingRule(node)) == null) break;
                return answer;
            }
        }
        Rule answer = null;
        ruleSet = this.ruleSets.get((Object)matchType);
        if (ruleSet != null) {
            answer = ruleSet.getMatchingRule(node);
        }
        if (answer == null && matchType != NodeType.ANY_NODE && (ruleSet = this.ruleSets.get((Object)matchType)) != null) {
            answer = ruleSet.getMatchingRule(node);
        }
        return answer;
    }

    protected RuleSet getRuleSet(NodeType matchType) {
        RuleSet ruleSet = this.ruleSets.get((Object)matchType);
        if (ruleSet == null) {
            RuleSet allRules;
            ruleSet = new RuleSet();
            this.ruleSets.put(matchType, ruleSet);
            if (matchType != NodeType.ANY_NODE && (allRules = this.ruleSets.get((Object)matchType)) != null) {
                ruleSet.addAll(allRules);
            }
        }
        return ruleSet;
    }

    protected Map<String, RuleSet> addToNameMap(Map<String, RuleSet> map, String name, Rule rule) {
        RuleSet ruleSet;
        if (map == null) {
            map = new HashMap<String, RuleSet>();
        }
        if ((ruleSet = map.get(name)) == null) {
            ruleSet = new RuleSet();
            map.put(name, ruleSet);
        }
        ruleSet.addRule(rule);
        return map;
    }

    protected void removeFromNameMap(Map<String, RuleSet> map, String name, Rule rule) {
        RuleSet ruleSet;
        if (map != null && (ruleSet = map.get(name)) != null) {
            ruleSet.removeRule(rule);
        }
    }
}

