/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.rule;

import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.DocumentFactory;
import org.act.xservices.rt.xom.rule.Pattern;

public class PriorityTest
extends AbstractTestCase {
    public static void main(String[] args) {
        TestRunner.run(PriorityTest.class);
    }

    public void testNameNode() throws Exception {
        this.testPriority("foo", 0.0);
    }

    public void testFilter() throws Exception {
        this.testPriority("foo[@id='123']", 0.5);
    }

    public void testURI() throws Exception {
        this.testPriority("foo:*", -0.25);
    }

    public void testAnyNode() throws Exception {
        this.testPriority("*", -0.5);
    }

    protected void testPriority(String expr, double priority) throws Exception {
        System.out.println("parsing: " + expr);
        Pattern pattern = DocumentFactory.getInstance().createPattern(expr);
        double d = pattern.getPriority();
        System.out.println("expr: " + expr + " has priority: " + d);
        System.out.println("pattern: " + pattern);
        PriorityTest.assertEquals((String)("expr: " + expr), (Object)new Double(priority), (Object)new Double(d));
    }
}

