/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.rule;

import java.util.ArrayList;
import java.util.Collections;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.rule.Rule;

public class RuleSet {
    private ArrayList rules = new ArrayList();
    private Rule[] ruleArray;

    public String toString() {
        return String.valueOf(super.toString()) + " [RuleSet: " + this.rules + " ]";
    }

    public Rule getMatchingRule(Node node) {
        Rule[] matches = this.getRuleArray();
        int i = matches.length - 1;
        while (i >= 0) {
            Rule rule = matches[i];
            if (rule.matches(node)) {
                return rule;
            }
            --i;
        }
        return null;
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
        this.ruleArray = null;
    }

    public void removeRule(Rule rule) {
        this.rules.remove(rule);
        this.ruleArray = null;
    }

    public void addAll(RuleSet that) {
        this.rules.addAll(that.rules);
        this.ruleArray = null;
    }

    protected Rule[] getRuleArray() {
        if (this.ruleArray == null) {
            Collections.sort(this.rules);
            int size = this.rules.size();
            this.ruleArray = new Rule[size];
            this.rules.toArray(this.ruleArray);
        }
        return this.ruleArray;
    }
}

