/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.tree;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.act.xservices.rt.xom.Branch;
import org.act.xservices.rt.xom.Comment;
import org.act.xservices.rt.xom.IllegalAddException;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Namespace;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.ProcessingInstruction;
import org.act.xservices.rt.xom.QName;
import org.act.xservices.rt.xom.tree.AbstractNode;
import org.act.xservices.rt.xom.tree.BackedList;
import org.act.xservices.rt.xom.tree.ContentListFacade;
import org.act.xservices.rt.xom.tree.LazyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBranch
extends AbstractNode
implements Branch {
    protected static final int DEFAULT_CONTENT_LIST_SIZE = 5;

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean hasContent() {
        return this.nodeCount() > 0;
    }

    @Override
    public List<Node> content() {
        List<Node> backingList = this.contentList();
        return new ContentListFacade<Node>(this, backingList);
    }

    @Override
    public String getText() {
        int size;
        List<Node> content = this.contentList();
        if (content != null && (size = content.size()) >= 1) {
            Node first = content.get(0);
            String firstText = this.getContentAsText(first);
            if (size == 1) {
                return firstText;
            }
            StringBuilder buffer = new StringBuilder(firstText);
            int i = 1;
            while (i < size) {
                Node node = content.get(i);
                buffer.append(this.getContentAsText(node));
                ++i;
            }
            return buffer.toString();
        }
        return "";
    }

    protected String getContentAsText(Node node) {
        switch (node.getNodeTypeEnum()) {
            case TEXT_NODE: 
            case CDATA_SECTION_NODE: 
            case ENTITY_REFERENCE_NODE: {
                return node.getText();
            }
        }
        return "";
    }

    protected String getContentAsStringValue(Node node) {
        switch (node.getNodeTypeEnum()) {
            case ELEMENT_NODE: 
            case TEXT_NODE: 
            case CDATA_SECTION_NODE: 
            case ENTITY_REFERENCE_NODE: {
                return node.getStringValue();
            }
        }
        return "";
    }

    public String getTextTrim() {
        String text = this.getText();
        StringBuilder textContent = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(text);
        while (tokenizer.hasMoreTokens()) {
            String str = tokenizer.nextToken();
            textContent.append(str);
            if (!tokenizer.hasMoreTokens()) continue;
            textContent.append(" ");
        }
        return textContent.toString();
    }

    @Override
    public void setProcessingInstructions(List<ProcessingInstruction> listOfPIs) {
        for (ProcessingInstruction pi : listOfPIs) {
            this.addNode(pi);
        }
    }

    @Override
    public Metaset addElement(String name) {
        Metaset node = this.getDocumentFactory().createElement(name);
        this.add(node);
        return node;
    }

    @Override
    public Metaset addElement(String qualifiedName, String namespaceURI) {
        Metaset node = this.getDocumentFactory().createElement(qualifiedName, namespaceURI);
        this.add(node);
        return node;
    }

    @Override
    public Metaset addElement(QName qname) {
        Metaset node = this.getDocumentFactory().createElement(qname);
        this.add(node);
        return node;
    }

    public Metaset addElement(String name, String prefix, String uri) {
        Namespace namespace = Namespace.get(prefix, uri);
        QName qName = this.getDocumentFactory().createQName(name, namespace);
        return this.addElement(qName);
    }

    @Override
    public void add(Node node) {
        switch (node.getNodeTypeEnum()) {
            case ELEMENT_NODE: {
                this.add((Metaset)node);
                break;
            }
            case COMMENT_NODE: {
                this.add((Comment)node);
                break;
            }
            case PROCESSING_INSTRUCTION_NODE: {
                this.add((ProcessingInstruction)node);
                break;
            }
            default: {
                this.invalidNodeTypeAddException(node);
            }
        }
    }

    @Override
    public boolean remove(Node node) {
        switch (node.getNodeTypeEnum()) {
            case ELEMENT_NODE: {
                return this.remove((Metaset)node);
            }
            case COMMENT_NODE: {
                return this.remove((Comment)node);
            }
            case PROCESSING_INSTRUCTION_NODE: {
                return this.remove((ProcessingInstruction)node);
            }
        }
        this.invalidNodeTypeAddException(node);
        return false;
    }

    @Override
    public void add(Comment comment) {
        this.addNode(comment);
    }

    @Override
    public void add(Metaset element) {
        this.addNode(element);
    }

    @Override
    public void add(ProcessingInstruction pi) {
        this.addNode(pi);
    }

    @Override
    public boolean remove(Comment comment) {
        return this.removeNode(comment);
    }

    @Override
    public boolean remove(Metaset element) {
        return this.removeNode(element);
    }

    @Override
    public boolean remove(ProcessingInstruction pi) {
        return this.removeNode(pi);
    }

    @Override
    public Metaset elementByID(String elementID) {
        int i = 0;
        int size = this.nodeCount();
        while (i < size) {
            Node node = this.node(i);
            if (node instanceof Metaset) {
                Metaset element = (Metaset)node;
                String id = this.elementID(element);
                if (id != null && id.equals(elementID)) {
                    return element;
                }
                if ((element = element.elementByID(elementID)) != null) {
                    return element;
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public void appendContent(Branch branch) {
        for (Node node : branch) {
            this.add((Node)node.clone());
        }
    }

    @Override
    public Node node(int index) {
        Node node = this.contentList().get(index);
        return node;
    }

    @Override
    public int nodeCount() {
        return this.contentList().size();
    }

    @Override
    public int indexOf(Node node) {
        return this.contentList().indexOf(node);
    }

    @Override
    public Iterator<Node> nodeIterator() {
        return this.contentList().iterator();
    }

    @Override
    public Iterator<Node> iterator() {
        return this.nodeIterator();
    }

    protected String elementID(Metaset element) {
        return element.attributeValue("ID");
    }

    protected abstract List<Node> contentList();

    protected List<Node> createContentList() {
        return new LazyList<Node>();
    }

    protected <T extends Node> BackedList<T> createResultList() {
        return new BackedList(this, this.contentList());
    }

    protected abstract void addNode(Node var1);

    protected abstract void addNode(int var1, Node var2);

    protected abstract boolean removeNode(Node var1);

    protected abstract void childAdded(Node var1);

    protected abstract void childRemoved(Node var1);

    protected void contentRemoved() {
        for (Node node : this.contentList()) {
            this.childRemoved(node);
        }
    }

    protected void invalidNodeTypeAddException(Node node) {
        throw new IllegalAddException("Invalid node type. Cannot add node: " + node + " to this branch: " + this);
    }
}

