/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.tree;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.act.xservices.rt.xom.Comment;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentType;
import org.act.xservices.rt.xom.IllegalAddException;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.NodeType;
import org.act.xservices.rt.xom.ProcessingInstruction;
import org.act.xservices.rt.xom.QName;
import org.act.xservices.rt.xom.Text;
import org.act.xservices.rt.xom.Visitor;
import org.act.xservices.rt.xom.io.OutputFormat;
import org.act.xservices.rt.xom.io.XMLWriter;
import org.act.xservices.rt.xom.tree.AbstractBranch;

public abstract class AbstractDocument
extends AbstractBranch
implements Document {
    protected static String encoding;

    public NodeType getNodeTypeEnum() {
        return NodeType.DOCUMENT_NODE;
    }

    public String getPath(Metaset context) {
        return "/";
    }

    public String getUniquePath(Metaset context) {
        return "/";
    }

    public Document getDocument() {
        return this;
    }

    public String getXMLEncoding() {
        return null;
    }

    public String getStringValue() {
        Metaset root = this.getRootElement();
        return root != null ? root.getStringValue() : "";
    }

    public String asXML() {
        OutputFormat format = new OutputFormat();
        format.setEncoding(encoding);
        try {
            StringWriter out = new StringWriter();
            XMLWriter writer = new XMLWriter(out, format);
            writer.write(this);
            writer.flush();
            return out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while generating textual representation: " + e.getMessage());
        }
    }

    public void write(Writer out) throws IOException {
        OutputFormat format = new OutputFormat();
        format.setEncoding(encoding);
        XMLWriter writer = new XMLWriter(out, format);
        writer.write(this);
    }

    public void accept(Visitor visitor) {
        List<Node> content;
        visitor.visit(this);
        DocumentType docType = this.getDocType();
        if (docType != null) {
            visitor.visit(docType);
        }
        if ((content = this.content()) != null) {
            for (Node object : content) {
                if (object instanceof String) {
                    Text text = this.getDocumentFactory().createText((String)((Object)object));
                    visitor.visit(text);
                    continue;
                }
                Node node = object;
                node.accept(visitor);
            }
        }
    }

    protected void toString(StringBuilder builder) {
        super.toString(builder);
        builder.append(" [Document: name ");
        builder.append(this.getName());
        builder.append(']');
    }

    public void normalize() {
        Metaset element = this.getRootElement();
        if (element != null) {
            element.normalize();
        }
    }

    public Document addComment(String comment) {
        Comment node = this.getDocumentFactory().createComment(comment);
        this.add(node);
        return this;
    }

    public Document addProcessingInstruction(String target, String data) {
        ProcessingInstruction node = this.getDocumentFactory().createProcessingInstruction(target, data);
        this.add(node);
        return this;
    }

    public Document addProcessingInstruction(String target, Map data) {
        ProcessingInstruction node = this.getDocumentFactory().createProcessingInstruction(target, data);
        this.add(node);
        return this;
    }

    public Metaset addElement(String name) {
        Metaset element = this.getDocumentFactory().createElement(name);
        this.add(element);
        return element;
    }

    public Metaset addElement(String qualifiedName, String namespaceURI) {
        Metaset element = this.getDocumentFactory().createElement(qualifiedName, namespaceURI);
        this.add(element);
        return element;
    }

    public Metaset addElement(QName qName) {
        Metaset element = this.getDocumentFactory().createElement(qName);
        this.add(element);
        return element;
    }

    public void setRootElement(Metaset rootElement) {
        this.clearContent();
        if (rootElement != null) {
            super.add(rootElement);
            this.rootElementAdded(rootElement);
        }
    }

    public void add(Metaset element) {
        this.checkAddElementAllowed(element);
        super.add(element);
        this.rootElementAdded(element);
    }

    public boolean remove(Metaset element) {
        boolean answer = super.remove(element);
        Metaset root = this.getRootElement();
        if (root != null && answer) {
            this.setRootElement(null);
        }
        element.setDocument(null);
        return answer;
    }

    public Node asXPathResult(Metaset parent) {
        return this;
    }

    protected void childAdded(Node node) {
        if (node != null) {
            node.setDocument(this);
        }
    }

    protected void childRemoved(Node node) {
        if (node != null) {
            node.setDocument(null);
        }
    }

    protected void checkAddElementAllowed(Metaset element) {
        Metaset root = this.getRootElement();
        if (root != null) {
            throw new IllegalAddException(this, (Node)element, "Cannot add another element to this Document as it already has a root element of: " + root.getQualifiedName());
        }
    }

    protected abstract void rootElementAdded(Metaset var1);

    public void setXMLEncoding(String enc) {
        encoding = enc;
    }
}

