/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.tree;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.act.xservices.rt.xom.DocumentType;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.NodeType;
import org.act.xservices.rt.xom.Visitor;
import org.act.xservices.rt.xom.dtd.InternalDeclaration;
import org.act.xservices.rt.xom.tree.AbstractNode;

public abstract class AbstractDocumentType
extends AbstractNode
implements DocumentType {
    public NodeType getNodeTypeEnum() {
        return NodeType.DOCUMENT_TYPE_NODE;
    }

    public String getName() {
        return this.getElementName();
    }

    public void setName(String name) {
        this.setElementName(name);
    }

    public String getPath(Metaset context) {
        return "";
    }

    public String getUniquePath(Metaset context) {
        return "";
    }

    public String getText() {
        List<InternalDeclaration> list = this.getInternalDeclarations();
        if (list != null && list.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (InternalDeclaration decl : list) {
                builder.append(decl.toString());
                builder.append('\n');
            }
            if (builder.length() > 0) {
                builder.setLength(builder.length() - 1);
            }
            return builder.toString();
        }
        return "";
    }

    protected void toString(StringBuilder builder) {
        super.toString(builder);
        builder.append(" [DocumentType: ");
        this.asXML(builder);
        builder.append(']');
    }

    public String asXML() {
        StringBuilder builder = new StringBuilder();
        this.asXML(builder);
        return builder.toString();
    }

    protected void asXML(StringBuilder builder) {
        String systemID;
        builder.append("<!DOCTYPE ");
        builder.append(this.getElementName());
        boolean hasPublicID = false;
        String publicID = this.getPublicID();
        if (publicID != null && publicID.length() > 0) {
            builder.append(" PUBLIC ");
            builder.append('\"');
            builder.append(publicID);
            builder.append('\"');
            hasPublicID = true;
        }
        if ((systemID = this.getSystemID()) != null && systemID.length() > 0) {
            if (!hasPublicID) {
                builder.append(" SYSTEM");
            }
            builder.append(" \"");
            builder.append(systemID);
            builder.append('\"');
        }
        builder.append('>');
    }

    public void write(Writer writer) throws IOException {
        List<InternalDeclaration> list;
        String systemID;
        writer.write("<!DOCTYPE ");
        writer.write(this.getElementName());
        boolean hasPublicID = false;
        String publicID = this.getPublicID();
        if (publicID != null && publicID.length() > 0) {
            writer.write(" PUBLIC \"");
            writer.write(publicID);
            writer.write(34);
            hasPublicID = true;
        }
        if ((systemID = this.getSystemID()) != null && systemID.length() > 0) {
            if (!hasPublicID) {
                writer.write(" SYSTEM");
            }
            writer.write(" \"");
            writer.write(systemID);
            writer.write(34);
        }
        if ((list = this.getInternalDeclarations()) != null && list.size() > 0) {
            writer.write(" [");
            for (InternalDeclaration decl : list) {
                writer.write("\n  ");
                writer.write(decl.toString());
            }
            writer.write("\n]");
        }
        writer.write(62);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

