/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.tree;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.act.xservices.rt.metaset.exception.QNameExpressionException;
import org.act.xservices.rt.metaset.query.FilterProcessor;
import org.act.xservices.rt.metaset.query.SelectorProcessor;
import org.act.xservices.rt.metaset.utils.ExpressionUtil;
import org.act.xservices.rt.xom.Attribute;
import org.act.xservices.rt.xom.CDATA;
import org.act.xservices.rt.xom.CharacterData;
import org.act.xservices.rt.xom.Comment;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentFactory;
import org.act.xservices.rt.xom.Entity;
import org.act.xservices.rt.xom.IllegalAddException;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Namespace;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.NodeHelper;
import org.act.xservices.rt.xom.NodeType;
import org.act.xservices.rt.xom.ProcessingInstruction;
import org.act.xservices.rt.xom.QName;
import org.act.xservices.rt.xom.Text;
import org.act.xservices.rt.xom.Visitor;
import org.act.xservices.rt.xom.io.OutputFormat;
import org.act.xservices.rt.xom.io.XMLWriter;
import org.act.xservices.rt.xom.tree.AbstractBranch;
import org.act.xservices.rt.xom.tree.AbstractDocument;
import org.act.xservices.rt.xom.tree.BackedList;
import org.act.xservices.rt.xom.tree.ContentListFacade;
import org.act.xservices.rt.xom.tree.NamespaceStack;
import org.act.xservices.rt.xom.tree.SingleIterator;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractElement
extends AbstractBranch
implements Metaset {
    private static final DocumentFactory DOCUMENT_FACTORY = DocumentFactory.getInstance();
    protected static final boolean VERBOSE_TOSTRING = false;
    protected static final boolean USE_STRINGVALUE_SEPARATOR = false;
    public static final char NL = '\n';
    public static final char CR = '\r';
    public static final String LS = System.getProperty("line.separator", new Character('\n').toString());
    protected List<Node> children = null;

    @Override
    public NodeType getNodeTypeEnum() {
        return NodeType.ELEMENT_NODE;
    }

    @Override
    public boolean isRootElement() {
        Metaset root;
        Document document = this.getDocument();
        return document != null && (root = document.getRootElement()) == this;
    }

    @Override
    public void setName(String name) {
        this.setQName(this.getDocumentFactory().createQName(name));
    }

    public void setNamespace(Namespace namespace) {
        this.setQName(this.getDocumentFactory().createQName(this.getName(), namespace));
    }

    public String getXPathNameStep() {
        String uri = this.getNamespaceURI();
        if (uri == null || uri.length() == 0) {
            return this.getName();
        }
        String prefix = this.getNamespacePrefix();
        if (prefix == null || prefix.length() == 0) {
            return "*[name()='" + this.getName() + "']";
        }
        return this.getQualifiedName();
    }

    @Override
    public String getPath(Metaset context) {
        if (this == context) {
            return ".";
        }
        Metaset parent = this.getParent();
        if (parent == null) {
            return "/" + this.getXPathNameStep();
        }
        if (parent == context) {
            return this.getXPathNameStep();
        }
        return String.valueOf(parent.getPath(context)) + "/" + this.getXPathNameStep();
    }

    @Override
    public String getUniquePath(Metaset context) {
        int idx;
        Metaset parent = this.getParent();
        if (parent == null) {
            return "/" + this.getXPathNameStep();
        }
        StringBuffer buffer = new StringBuffer();
        if (parent != context) {
            buffer.append(parent.getUniquePath(context));
            buffer.append("/");
        }
        buffer.append(this.getXPathNameStep());
        List<Metaset> mySiblings = parent.elements(this.getQName());
        if (mySiblings.size() > 1 && (idx = mySiblings.indexOf(this)) >= 0) {
            buffer.append("[");
            buffer.append(Integer.toString(++idx));
            buffer.append("]");
        }
        return buffer.toString();
    }

    @Override
    public String asXML() {
        try {
            StringWriter out = new StringWriter();
            XMLWriter writer = new XMLWriter(out, new OutputFormat());
            writer.write(this);
            writer.flush();
            return out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while generating textual representation: " + e.getMessage());
        }
    }

    @Override
    public void write(Writer out) throws IOException {
        XMLWriter writer = new XMLWriter(out, new OutputFormat());
        writer.write(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
        int i = 0;
        int size = this.attributeCount();
        while (i < size) {
            Attribute attribute = this.attribute(i);
            visitor.visit(attribute);
            ++i;
        }
        i = 0;
        size = this.nodeCount();
        while (i < size) {
            Node node = this.node(i);
            node.accept(visitor);
            ++i;
        }
    }

    @Override
    protected void toString(StringBuilder builder) {
        String uri = this.getNamespaceURI();
        super.toString(builder);
        builder.append(" [Element: <");
        builder.append(this.getQualifiedName());
        if (uri != null && uri.length() > 0) {
            builder.append(" uri: ");
            builder.append(uri);
        }
        builder.append(" attributes: ");
        builder.append(this.attributeList());
        builder.append("/>]");
    }

    @Override
    public Namespace getNamespace() {
        return this.getQName().getNamespace();
    }

    @Override
    public String getName() {
        return this.getQName().getName();
    }

    @Override
    public String getNamespacePrefix() {
        return this.getQName().getNamespacePrefix();
    }

    @Override
    public String getNamespaceURI() {
        return this.getQName().getNamespaceURI();
    }

    @Override
    public String getQualifiedName() {
        return this.getQName().getQualifiedName();
    }

    @Override
    public Object getData() {
        return this.getText();
    }

    @Override
    public void setData(Object data) {
    }

    @Override
    public Node node(int index) {
        if (index >= 0) {
            List<Node> list = this.contentList();
            if (index >= list.size()) {
                return null;
            }
            return list.get(index);
        }
        return null;
    }

    @Override
    public int indexOf(Node node) {
        return this.contentList().indexOf(node);
    }

    @Override
    public int nodeCount() {
        return this.contentList().size();
    }

    @Override
    public Iterator<Node> nodeIterator() {
        return this.contentList().iterator();
    }

    @Override
    public Metaset element(String name) {
        for (Node node : this.contentList()) {
            Metaset element = NodeHelper.nodeAsElement(node);
            if (element == null || !name.equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    @Override
    public Metaset element(QName qName) {
        for (Node node : this.contentList()) {
            Metaset element = NodeHelper.nodeAsElement(node);
            if (element == null || !qName.equals(element.getQName())) continue;
            return element;
        }
        return null;
    }

    public Metaset element(String name, Namespace namespace) {
        return this.element(this.getDocumentFactory().createQName(name, namespace));
    }

    @Override
    public List<Metaset> elements() {
        BackedList<Metaset> answer = this.createResultList();
        for (Node node : this.contentList()) {
            NodeHelper.appendElementLocal(node, answer);
        }
        return answer;
    }

    @Override
    public List<Metaset> elements(String name) {
        BackedList<Metaset> answer = this.createResultList();
        for (Node node : this.contentList()) {
            NodeHelper.appendElementNamedLocal(node, answer, name);
        }
        return answer;
    }

    @Override
    public List<Metaset> elements(QName qName) {
        BackedList<Metaset> answer = this.createResultList();
        for (Node node : this.contentList()) {
            NodeHelper.appendElementQNamedLocal(node, answer, qName);
        }
        return answer;
    }

    public List elements(String name, Namespace namespace) {
        return this.elements(this.getDocumentFactory().createQName(name, namespace));
    }

    @Override
    public Iterator<Metaset> elementIterator() {
        return this.elements().iterator();
    }

    @Override
    public Iterator<Metaset> elementIterator(String name) {
        return this.elements(name).iterator();
    }

    @Override
    public Iterator<Metaset> elementIterator(QName qName) {
        return this.elements(qName).iterator();
    }

    public Iterator<Metaset> elementIterator(String name, Namespace ns) {
        return this.elementIterator(this.getDocumentFactory().createQName(name, ns));
    }

    @Override
    public List<Attribute> attributes() {
        return new ContentListFacade<Attribute>(this, this.attributeList());
    }

    @Override
    public Iterator<Attribute> attributeIterator() {
        return this.attributeList().iterator();
    }

    @Override
    public Attribute attribute(int index) {
        return this.attributeList().get(index);
    }

    @Override
    public int attributeCount() {
        return this.attributeList().size();
    }

    @Override
    public Attribute attribute(String name) {
        for (Attribute attribute : this.attributeList()) {
            if (!name.equals(attribute.getName())) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public Attribute attribute(QName qName) {
        for (Attribute attribute : this.attributeList()) {
            if (!qName.equals(attribute.getQName())) continue;
            return attribute;
        }
        return null;
    }

    public Attribute attribute(String name, Namespace namespace) {
        return this.attribute(this.getDocumentFactory().createQName(name, namespace));
    }

    public void setAttributes(Attributes attributes, NamespaceStack namespaceStack, boolean noNamespaceAttributes) {
        int size = attributes.getLength();
        if (size > 0) {
            DocumentFactory factory = this.getDocumentFactory();
            if (size == 1) {
                String name = attributes.getQName(0);
                if (noNamespaceAttributes || !name.startsWith("xmlns")) {
                    String attributeURI = attributes.getURI(0);
                    String attributeLocalName = attributes.getLocalName(0);
                    String attributeValue = attributes.getValue(0);
                    QName attributeQName = namespaceStack.getAttributeQName(attributeURI, attributeLocalName, name);
                    this.add(factory.createAttribute((Metaset)this, attributeQName, attributeValue));
                }
            } else {
                List<Attribute> list = this.attributeList(size);
                list.clear();
                int i = 0;
                while (i < size) {
                    String attributeName = attributes.getQName(i);
                    if (noNamespaceAttributes || !attributeName.startsWith("xmlns")) {
                        String attributeURI = attributes.getURI(i);
                        String attributeLocalName = attributes.getLocalName(i);
                        String attributeValue = attributes.getValue(i);
                        QName attributeQName = namespaceStack.getAttributeQName(attributeURI, attributeLocalName, attributeName);
                        Attribute attribute = factory.createAttribute((Metaset)this, attributeQName, attributeValue);
                        list.add(attribute);
                        this.childAdded(attribute);
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public String attributeValue(String name) {
        return NodeHelper.getAttributeValue(this.attribute(name), null);
    }

    @Override
    public String attributeValue(QName qName) {
        return NodeHelper.getAttributeValue(this.attribute(qName), null);
    }

    @Override
    public String attributeValue(String name, String defaultValue) {
        return NodeHelper.getAttributeValue(this.attribute(name), defaultValue);
    }

    @Override
    public String attributeValue(QName qName, String defaultValue) {
        return NodeHelper.getAttributeValue(this.attribute(qName), defaultValue);
    }

    @Override
    public void add(Attribute attribute) {
        if (attribute.getParent() != null) {
            String message = "The Attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"";
            throw new IllegalAddException(this, (Node)attribute, message);
        }
        if (attribute.getValue() == null) {
            Attribute oldAttribute = this.attribute(attribute.getQName());
            if (oldAttribute != null) {
                this.remove(oldAttribute);
            }
        } else {
            this.attributeList().add(attribute);
            this.childAdded(attribute);
        }
    }

    @Override
    public boolean remove(Attribute attribute) {
        List<Attribute> list = this.attributeList();
        boolean answer = list.remove(attribute);
        if (answer) {
            this.childRemoved(attribute);
        } else {
            Attribute copy = this.attribute(attribute.getQName());
            if (copy != null) {
                list.remove(copy);
                answer = true;
            }
        }
        return answer;
    }

    @Override
    public List<ProcessingInstruction> processingInstructions() {
        List<Node> list = this.contentList();
        BackedList<ProcessingInstruction> answer = this.createResultList();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Node node = list.get(i);
            if (node instanceof ProcessingInstruction) {
                answer.addLocal((ProcessingInstruction)node);
            }
            ++i;
        }
        return answer;
    }

    @Override
    public List<ProcessingInstruction> processingInstructions(String target) {
        List<Node> list = this.contentList();
        BackedList<ProcessingInstruction> answer = this.createResultList();
        int size = list.size();
        int i = 0;
        while (i < size) {
            ProcessingInstruction pi;
            Node node = list.get(i);
            if (node instanceof ProcessingInstruction && target.equals((pi = (ProcessingInstruction)node).getName())) {
                answer.addLocal(pi);
            }
            ++i;
        }
        return answer;
    }

    @Override
    public ProcessingInstruction processingInstruction(String target) {
        List<Node> list = this.contentList();
        int size = list.size();
        int i = 0;
        while (i < size) {
            ProcessingInstruction pi;
            Node node = list.get(i);
            if (node instanceof ProcessingInstruction && target.equals((pi = (ProcessingInstruction)node).getName())) {
                return pi;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean removeProcessingInstruction(String target) {
        List<Node> list = this.contentList();
        Iterator<Node> iter = list.iterator();
        while (iter.hasNext()) {
            ProcessingInstruction pi;
            Node node = iter.next();
            if (!(node instanceof ProcessingInstruction) || !target.equals((pi = (ProcessingInstruction)node).getName())) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public Node getXPathResult(int index) {
        Node answer = this.node(index);
        if (answer != null && !answer.supportsParent()) {
            return answer.asXPathResult(this);
        }
        return answer;
    }

    @Override
    public Metaset addAttribute(String name, String value) {
        Attribute attribute = this.attribute(name);
        if (value != null) {
            if (attribute == null) {
                this.add(this.getDocumentFactory().createAttribute((Metaset)this, name, value));
            } else if (attribute.isReadOnly()) {
                this.remove(attribute);
                this.add(this.getDocumentFactory().createAttribute((Metaset)this, name, value));
            } else {
                attribute.setValue(value);
            }
        } else if (attribute != null) {
            this.remove(attribute);
        }
        return this;
    }

    @Override
    public Metaset addAttribute(QName qName, String value) {
        Attribute attribute = this.attribute(qName);
        if (value != null) {
            if (attribute == null) {
                this.add(this.getDocumentFactory().createAttribute((Metaset)this, qName, value));
            } else if (attribute.isReadOnly()) {
                this.remove(attribute);
                this.add(this.getDocumentFactory().createAttribute((Metaset)this, qName, value));
            } else {
                attribute.setValue(value);
            }
        } else if (attribute != null) {
            this.remove(attribute);
        }
        return this;
    }

    @Override
    public Metaset addCDATA(String cdata) {
        CDATA node = this.getDocumentFactory().createCDATA(cdata);
        this.addNewNode(node);
        return this;
    }

    @Override
    public Metaset addComment(String comment) {
        Comment node = this.getDocumentFactory().createComment(comment);
        this.addNewNode(node);
        return this;
    }

    @Override
    public Metaset addElement(String name) {
        Metaset node;
        DocumentFactory factory = this.getDocumentFactory();
        int index = name.indexOf(":");
        String prefix = "";
        String localName = name;
        Namespace namespace = null;
        if (index > 0) {
            prefix = name.substring(0, index);
            localName = name.substring(index + 1);
            namespace = this.getNamespaceForPrefix(prefix);
            if (namespace == null) {
                throw new IllegalAddException("No such namespace prefix: " + prefix + " is in scope on: " + this + " so cannot add element: " + name);
            }
        } else {
            namespace = this.getNamespaceForPrefix("");
        }
        if (namespace != null) {
            QName qname = factory.createQName(localName, namespace);
            node = factory.createElement(qname);
        } else {
            node = factory.createElement(name);
        }
        this.addNewNode(node);
        return node;
    }

    @Override
    public Metaset addEntity(String name, String text) {
        Entity node = this.getDocumentFactory().createEntity(name, text);
        this.addNewNode(node);
        return this;
    }

    @Override
    public Metaset addNamespace(String prefix, String uri) {
        Namespace node = this.getDocumentFactory().createNamespace(prefix, uri);
        this.addNewNode(node);
        return this;
    }

    @Override
    public Metaset addProcessingInstruction(String target, String data) {
        ProcessingInstruction node = this.getDocumentFactory().createProcessingInstruction(target, data);
        this.addNewNode(node);
        return this;
    }

    @Override
    public Metaset addProcessingInstruction(String target, Map data) {
        ProcessingInstruction node = this.getDocumentFactory().createProcessingInstruction(target, data);
        this.addNewNode(node);
        return this;
    }

    @Override
    public Metaset addText(String text) {
        Text node = this.getDocumentFactory().createText(text);
        this.addNewNode(node);
        return this;
    }

    @Override
    public void add(Node node) {
        switch (node.getNodeTypeEnum()) {
            case ELEMENT_NODE: {
                this.add((Metaset)node);
                break;
            }
            case ATTRIBUTE_NODE: {
                this.add((Attribute)node);
                break;
            }
            case TEXT_NODE: {
                this.add((Text)node);
                break;
            }
            case CDATA_SECTION_NODE: {
                this.add((CDATA)node);
                break;
            }
            case ENTITY_REFERENCE_NODE: {
                this.add((Entity)node);
                break;
            }
            case PROCESSING_INSTRUCTION_NODE: {
                this.add((ProcessingInstruction)node);
                break;
            }
            case COMMENT_NODE: {
                this.add((Comment)node);
                break;
            }
            case NAMESPACE_NODE: {
                this.add((Namespace)node);
                break;
            }
            default: {
                this.invalidNodeTypeAddException(node);
            }
        }
    }

    @Override
    public boolean remove(Node node) {
        switch (node.getNodeTypeEnum()) {
            case ELEMENT_NODE: {
                return this.remove((Metaset)node);
            }
            case ATTRIBUTE_NODE: {
                return this.remove((Attribute)node);
            }
            case TEXT_NODE: {
                return this.remove((Text)node);
            }
            case CDATA_SECTION_NODE: {
                return this.remove((CDATA)node);
            }
            case ENTITY_REFERENCE_NODE: {
                return this.remove((Entity)node);
            }
            case PROCESSING_INSTRUCTION_NODE: {
                return this.remove((ProcessingInstruction)node);
            }
            case COMMENT_NODE: {
                return this.remove((Comment)node);
            }
            case NAMESPACE_NODE: {
                return this.remove((Namespace)node);
            }
        }
        return false;
    }

    @Override
    public void add(CDATA cdata) {
        this.addNode(cdata);
    }

    @Override
    public void add(Comment comment) {
        this.addNode(comment);
    }

    @Override
    public void add(Metaset element) {
        this.addNode(element);
    }

    @Override
    public void add(Entity entity) {
        this.addNode(entity);
    }

    @Override
    public void add(Namespace namespace) {
        this.addNode(namespace);
    }

    @Override
    public void add(ProcessingInstruction pi) {
        this.addNode(pi);
    }

    @Override
    public void add(Text text) {
        this.addNode(text);
    }

    @Override
    public boolean remove(CDATA cdata) {
        return this.removeNode(cdata);
    }

    @Override
    public boolean remove(Comment comment) {
        return this.removeNode(comment);
    }

    @Override
    public boolean remove(Metaset element) {
        return this.removeNode(element);
    }

    @Override
    public boolean remove(Entity entity) {
        return this.removeNode(entity);
    }

    @Override
    public boolean remove(Namespace namespace) {
        return this.removeNode(namespace);
    }

    @Override
    public boolean remove(ProcessingInstruction pi) {
        return this.removeNode(pi);
    }

    @Override
    public boolean remove(Text text) {
        return this.removeNode(text);
    }

    @Override
    public boolean hasMixedContent() {
        List<Node> content = this.contentList();
        if (content == null || content.isEmpty() || content.size() < 2) {
            return false;
        }
        Class<?> prevClass = null;
        for (Node node : content) {
            Class<?> newClass = node.getClass();
            if (newClass == prevClass) continue;
            if (prevClass != null) {
                return true;
            }
            prevClass = newClass;
        }
        return false;
    }

    @Override
    public boolean isTextOnly() {
        List<Node> content = this.contentList();
        if (content == null || content.isEmpty()) {
            return true;
        }
        for (Node node : content) {
            if (node instanceof CharacterData) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setText(String text) {
        List<Node> allContent = this.contentList();
        if (allContent != null) {
            Iterator<Node> it = allContent.iterator();
            while (it.hasNext()) {
                Node node = it.next();
                switch (node.getNodeTypeEnum()) {
                    case TEXT_NODE: 
                    case CDATA_SECTION_NODE: 
                    case ENTITY_REFERENCE_NODE: {
                        it.remove();
                    }
                }
            }
        }
        this.addText(text);
    }

    @Override
    public String getStringValue() {
        List<Node> list = this.contentList();
        int size = list.size();
        if (size > 0) {
            if (size == 1) {
                return this.getContentAsStringValue(list.get(0));
            }
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < size) {
                Node node = list.get(i);
                String string = this.getContentAsStringValue(node);
                if (string.length() > 0) {
                    buffer.append(string);
                }
                ++i;
            }
            return buffer.toString();
        }
        return "";
    }

    @Override
    public void normalize() {
        List<Node> content = this.contentList();
        CharacterData previousText = null;
        int i = 0;
        while (i < content.size()) {
            Node node = content.get(i);
            if (node instanceof Text) {
                Text text = (Text)node;
                if (previousText != null) {
                    previousText.appendText(text.getText());
                    this.remove(text);
                    continue;
                }
                String value = text.getText();
                if (value == null || value.length() <= 0) {
                    this.remove(text);
                    continue;
                }
                previousText = text;
                ++i;
                continue;
            }
            if (node instanceof Metaset) {
                Metaset element = (Metaset)node;
                element.normalize();
            }
            previousText = null;
            ++i;
        }
    }

    @Override
    public String elementText(String name) {
        Metaset element = this.element(name);
        return element != null ? element.getText() : null;
    }

    @Override
    public String elementText(QName qName) {
        Metaset element = this.element(qName);
        return element != null ? element.getText() : null;
    }

    @Override
    public String elementTextTrim(String name) {
        Metaset element = this.element(name);
        return element != null ? element.getTextTrim() : null;
    }

    @Override
    public String elementTextTrim(QName qName) {
        Metaset element = this.element(qName);
        return element != null ? element.getTextTrim() : null;
    }

    @Override
    public void appendAttributes(Metaset element) {
        int i = 0;
        int size = element.attributeCount();
        while (i < size) {
            Attribute attribute = element.attribute(i);
            if (attribute.supportsParent()) {
                this.addAttribute(attribute.getQName(), attribute.getValue());
            } else {
                this.add(attribute);
            }
            ++i;
        }
    }

    @Override
    public Metaset createCopy() {
        Metaset clone = this.createElement(this.getQName());
        clone.appendAttributes(this);
        clone.appendContent(this);
        return clone;
    }

    @Override
    public Metaset createCopy(String name) {
        Metaset clone = this.createElement(name);
        clone.appendAttributes(this);
        clone.appendContent(this);
        return clone;
    }

    @Override
    public Metaset createCopy(QName qName) {
        Metaset clone = this.createElement(qName);
        clone.appendAttributes(this);
        clone.appendContent(this);
        return clone;
    }

    @Override
    public QName getQName(String qualifiedName) {
        Namespace namespace;
        String prefix = "";
        String localName = qualifiedName;
        int index = qualifiedName.indexOf(":");
        if (index > 0) {
            prefix = qualifiedName.substring(0, index);
            localName = qualifiedName.substring(index + 1);
        }
        if ((namespace = this.getNamespaceForPrefix(prefix)) != null) {
            return this.getDocumentFactory().createQName(localName, namespace);
        }
        return this.getDocumentFactory().createQName(localName);
    }

    @Override
    public Namespace getNamespaceForPrefix(String prefix) {
        Namespace answer;
        if (prefix == null) {
            prefix = "";
        }
        if (prefix.equals(this.getNamespacePrefix())) {
            return this.getNamespace();
        }
        if (prefix.equals("xml")) {
            return Namespace.XML_NAMESPACE;
        }
        List<Node> list = this.contentList();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Namespace namespace;
            Node object = list.get(i);
            if (object instanceof Namespace && prefix.equals((namespace = (Namespace)object).getPrefix())) {
                return namespace;
            }
            ++i;
        }
        Metaset parent = this.getParent();
        if (parent != null && (answer = parent.getNamespaceForPrefix(prefix)) != null) {
            return answer;
        }
        if (prefix == null || prefix.length() <= 0) {
            return Namespace.NO_NAMESPACE;
        }
        return null;
    }

    @Override
    public Namespace getNamespaceForURI(String uri) {
        if (uri == null || uri.length() <= 0) {
            return Namespace.NO_NAMESPACE;
        }
        if (uri.equals(this.getNamespaceURI())) {
            return this.getNamespace();
        }
        List<Node> list = this.contentList();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Namespace namespace;
            Node object = list.get(i);
            if (object instanceof Namespace && uri.equals((namespace = (Namespace)object).getURI())) {
                return namespace;
            }
            ++i;
        }
        return null;
    }

    @Override
    public List<Namespace> getNamespacesForURI(String uri) {
        BackedList<Namespace> answer = this.createResultList();
        List<Node> list = this.contentList();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Node node = list.get(i);
            if (node instanceof Namespace && ((Namespace)node).getURI().equals(uri)) {
                answer.addLocal((Namespace)node);
            }
            ++i;
        }
        return answer;
    }

    @Override
    public List<Namespace> declaredNamespaces() {
        BackedList<Namespace> answer = this.createResultList();
        List<Node> list = this.contentList();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Node node = list.get(i);
            if (node instanceof Namespace) {
                answer.addLocal((Namespace)node);
            }
            ++i;
        }
        return answer;
    }

    @Override
    public List<Namespace> additionalNamespaces() {
        List<Node> list = this.contentList();
        int size = list.size();
        BackedList<Namespace> answer = this.createResultList();
        int i = 0;
        while (i < size) {
            Namespace namespace;
            Node node = list.get(i);
            if (node instanceof Namespace && !(namespace = (Namespace)node).equals(this.getNamespace())) {
                answer.addLocal(namespace);
            }
            ++i;
        }
        return answer;
    }

    public List<Namespace> additionalNamespaces(String defaultNamespaceURI) {
        List<Node> list = this.contentList();
        BackedList<Namespace> answer = this.createResultList();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Namespace namespace;
            Node node = list.get(i);
            if (node instanceof Namespace && !defaultNamespaceURI.equals((namespace = (Namespace)node).getURI())) {
                answer.addLocal(namespace);
            }
            ++i;
        }
        return answer;
    }

    public void ensureAttributesCapacity(int minCapacity) {
        List<Attribute> list;
        if (minCapacity > 1 && (list = this.attributeList()) instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)list;
            arrayList.ensureCapacity(minCapacity);
        }
    }

    protected Metaset createElement(String name) {
        return this.getDocumentFactory().createElement(name);
    }

    protected Metaset createElement(QName qName) {
        return this.getDocumentFactory().createElement(qName);
    }

    @Override
    protected void addNode(Node node) {
        if (node.getParent() != null) {
            String message = "The Node already has an existing parent of \"" + node.getParent().getQualifiedName() + "\"";
            throw new IllegalAddException(this, node, message);
        }
        this.addNewNode(node);
    }

    @Override
    protected void addNode(int index, Node node) {
        if (node.getParent() != null) {
            String message = "The Node already has an existing parent of \"" + node.getParent().getQualifiedName() + "\"";
            throw new IllegalAddException(this, node, message);
        }
        this.addNewNode(index, node);
    }

    protected void addNewNode(Node node) {
        this.contentList().add(node);
        this.childAdded(node);
    }

    protected void addNewNode(int index, Node node) {
        this.contentList().add(index, node);
        this.childAdded(node);
    }

    @Override
    protected boolean removeNode(Node node) {
        boolean answer = this.contentList().remove(node);
        if (answer) {
            this.childRemoved(node);
        }
        return answer;
    }

    @Override
    protected void childAdded(Node node) {
        if (node != null) {
            node.setParent(this);
        }
    }

    @Override
    protected void childRemoved(Node node) {
        if (node != null) {
            node.setParent(null);
            node.setDocument(null);
        }
    }

    protected abstract List<Attribute> attributeList();

    protected abstract List<Attribute> attributeList(int var1);

    @Override
    protected DocumentFactory getDocumentFactory() {
        DocumentFactory factory;
        QName qName = this.getQName();
        if (qName != null && (factory = qName.getDocumentFactory()) != null) {
            return factory;
        }
        return DOCUMENT_FACTORY;
    }

    protected List<Attribute> createAttributeList() {
        return this.createAttributeList(5);
    }

    protected List<Attribute> createAttributeList(int size) {
        return new ArrayList<Attribute>(size);
    }

    @Deprecated
    protected <T> Iterator<T> createSingleIterator(T result) {
        return new SingleIterator<T>(result);
    }

    @Override
    public boolean removeChildren(Metaset childElement) {
        return childElement.detach() != null;
    }

    @Override
    public String getFullStringName() {
        String nsuri = this.getNamespaceURI();
        if ("".equals(nsuri)) {
            return this.getName();
        }
        return "{" + this.getNamespaceURI() + "}" + this.getName();
    }

    @Override
    public boolean removeAttributeByName(String attrName) {
        try {
            QName attrQName = ExpressionUtil.parseQNameString(attrName);
            Iterator<Attribute> attris = this.attributeIterator();
            if (attris.hasNext()) {
                Attribute attr = attris.next();
                if (ExpressionUtil.matchAttributeQName(attrQName, attr.getQName())) {
                    this.remove(attr);
                }
                return true;
            }
            return false;
        }
        catch (QNameExpressionException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String toXML() {
        String result = "";
        String qName = "";
        Iterator<Metaset> children = this.elementIterator();
        if (this.getName().equals("")) {
            while (children.hasNext()) {
                result = String.valueOf(result) + children.next().toXML();
            }
        } else {
            qName = this.getNamespace() != null && this.getNamespace().getPrefix() != null && !this.getNamespace().getPrefix().equals("") ? String.valueOf(this.getNamespace().getPrefix()) + ":" + this.getName() : this.getName();
            result = "<" + qName;
            for (Namespace ns : this.declaredNamespaces()) {
                result = String.valueOf(result) + " xmlns";
                if (ns.getPrefix() != null && !ns.getPrefix().equals("")) {
                    result = String.valueOf(result) + ":" + ns.getPrefix();
                }
                result = String.valueOf(result) + "=\"" + ns.getURI() + "\"";
            }
            Iterator<Attribute> attris = this.attributeIterator();
            while (attris.hasNext()) {
                result = String.valueOf(result) + " " + attris.next().asXML();
            }
            String value = this.getText();
            if (children.hasNext()) {
                result = String.valueOf(result) + ">";
                if (value != "") {
                    result = String.valueOf(result) + AbstractElement.normalize(value);
                }
                while (children.hasNext()) {
                    result = String.valueOf(result) + children.next().toXML();
                }
                result = String.valueOf(result) + "</" + qName + ">";
            } else if (value != "") {
                result = String.valueOf(result) + ">";
                result = String.valueOf(result) + AbstractElement.normalize(value);
                result = String.valueOf(result) + "</" + qName + ">";
            } else {
                result = String.valueOf(result) + "/>";
            }
        }
        return result;
    }

    @Override
    public String toFormatXML() {
        String result = "";
        if (this.getName().equals("")) {
            for (Metaset child : this.elements()) {
                result = String.valueOf(result) + child.asXML();
            }
        } else {
            result = this.asXML();
        }
        return result;
    }

    @Override
    public String toDocument() {
        String encoding = AbstractDocument.encoding;
        if (encoding == null) {
            return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + this.toXML();
        }
        return "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>" + this.toXML();
    }

    @Override
    public String toFormatDocument() {
        String encoding = AbstractDocument.encoding;
        if (encoding == null) {
            return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + this.toFormatXML();
        }
        return "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>" + this.toFormatXML();
    }

    @Override
    public Metaset car() {
        return this.elements().get(0);
    }

    @Override
    public Metaset cdr() {
        Metaset result = this.car();
        if (result != null) {
            result.detach();
        }
        return result;
    }

    @Override
    public int getHeight() {
        Iterator<Metaset> childsList = this.elementIterator();
        if (!childsList.hasNext()) {
            return 0;
        }
        int height = 0;
        while (childsList.hasNext()) {
            Metaset met = childsList.next();
            int tmp = met.getHeight();
            if (tmp <= height) continue;
            height = tmp;
        }
        return height + 1;
    }

    @Override
    public int getLeafCount() {
        Iterator<Metaset> childsList = this.elementIterator();
        if (!childsList.hasNext()) {
            return 1;
        }
        int count = 0;
        while (childsList.hasNext()) {
            Metaset met = childsList.next();
            count += met.getLeafCount();
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        if (this.nodeCount() > 0) {
            return false;
        }
        return this.children == null;
    }

    @Override
    public int getMetasetPosition(Metaset childMetaset) {
        return this.indexOf(childMetaset);
    }

    @Override
    public void insert(Metaset child, int position) {
        this.addNode(position, child);
    }

    @Override
    public void encapsulatedChild(Metaset child) {
        if (this.children == null) {
            this.children = new ArrayList<Node>();
        }
        this.children.add(child);
    }

    @Override
    public boolean addAttribute(String pathExp, Attribute attribute) {
        if (attribute == null) {
            return false;
        }
        try {
            Metaset result = this.filter(pathExp);
            if (result != null) {
                Iterator<Metaset> children = result.elementIterator();
                while (children.hasNext()) {
                    children.next().add((Attribute)attribute.clone());
                }
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean addChildren(String pathExp, Metaset child) {
        if (child == null) {
            return false;
        }
        Metaset result = this.filter(pathExp);
        if (result != null) {
            Iterator<Metaset> children = result.elementIterator();
            while (children.hasNext()) {
                children.next().add((Metaset)child.clone());
            }
            return true;
        }
        return false;
    }

    @Override
    public Metaset filter(String pathExp) {
        return FilterProcessor.getInstance().filter(pathExp, (Metaset)this);
    }

    @Override
    public Metaset filter(String path, String attrName) {
        return FilterProcessor.getInstance().filter(String.valueOf(path) + "@" + attrName, (Metaset)this);
    }

    @Override
    public Metaset filter(String path, String attrName, String attrValue) {
        return FilterProcessor.getInstance().filter(String.valueOf(path) + "@" + attrName + "=" + "'" + attrValue + "'", (Metaset)this);
    }

    @Override
    public boolean removeAttribute(String pathExp, Attribute attribute) {
        if (attribute == null) {
            return false;
        }
        Metaset result = this.filter(pathExp);
        if (result != null) {
            Iterator<Metaset> children = result.elementIterator();
            while (children.hasNext()) {
                children.next().remove(attribute);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAttributeByPath(String pathExp, String attrName) {
        try {
            QName attrQName = ExpressionUtil.parseQNameString(attrName);
            Metaset result = this.filter(pathExp);
            if (result != null) {
                Iterator<Metaset> children = result.elementIterator();
                while (children.hasNext()) {
                    Metaset met = children.next();
                    Iterator<Attribute> attris = met.attributeIterator();
                    while (attris.hasNext()) {
                        Attribute attr = attris.next();
                        if (!ExpressionUtil.matchAttributeQName(attrQName, attr.getQName())) continue;
                        met.remove(attr);
                    }
                }
                return true;
            }
            return false;
        }
        catch (QNameExpressionException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean removeAttributeByPath(String pathExp, String attrName, String attrValue) {
        try {
            QName attrQName = ExpressionUtil.parseQNameString(attrName);
            Metaset result = this.filter(pathExp);
            if (result != null) {
                Iterator<Metaset> children = result.elementIterator();
                while (children.hasNext()) {
                    Metaset met = children.next();
                    Iterator<Attribute> attris = met.attributeIterator();
                    while (attris.hasNext()) {
                        Attribute attr = attris.next();
                        if (!ExpressionUtil.matchAttributeQName(attrQName, attr.getQName()) || !attr.getValue().equals(attrValue)) continue;
                        met.remove(attr);
                    }
                }
                return true;
            }
            return false;
        }
        catch (QNameExpressionException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean removeChildren(String pathExp, Metaset child) {
        if (child == null) {
            return false;
        }
        Metaset result = this.filter(pathExp);
        if (result != null) {
            Iterator<Metaset> children = result.elementIterator();
            while (children.hasNext()) {
                if (children.next().removeChildren(child)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeElements(String pathExp) {
        Iterator<Metaset> children;
        Metaset result = this.filter(pathExp);
        if (result != null && (children = result.elementIterator()).hasNext()) {
            return children.next().detach() != null;
        }
        return false;
    }

    @Override
    public String selectorAttributeValue(String pathExp, String attrName) {
        return SelectorProcessor.getInstance().selectorAttributeValue(pathExp, attrName, this);
    }

    @Override
    public QName selectorElementName(String pathExp) {
        return SelectorProcessor.getInstance().selectorElementName(pathExp, this);
    }

    @Override
    public List<String> selectorsAttributeValue(String pathExp, String attrLocalName) {
        return SelectorProcessor.getInstance().selectorsAttributeValue(pathExp, attrLocalName, this);
    }

    @Override
    public List<String> selectorsAttributeValueByXPath(String pathExp, String attrLocalName, Map<String, String> namespaceMap) {
        return SelectorProcessor.getInstance().selectorAttributeValueByXPath(pathExp, attrLocalName, this, namespaceMap);
    }

    @Override
    public List<QName> selectorsElementName(String pathExp) {
        return SelectorProcessor.getInstance().selectorsElementName(pathExp, this);
    }

    public static String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                case '\n': {
                    if (i > 0) {
                        char lastChar = str.charAt(str.length() - 1);
                        if (lastChar != '\r') {
                            str.append(LS);
                            break;
                        }
                        str.append('\n');
                        break;
                    }
                    str.append(LS);
                    break;
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }
}

