/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.tree;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentFactory;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.NodeFilter;
import org.act.xservices.rt.xom.NodeType;
import org.act.xservices.rt.xom.XPath;
import org.act.xservices.rt.xom.rule.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNode
implements Node,
Cloneable,
Serializable {
    private static final DocumentFactory DOCUMENT_FACTORY = DocumentFactory.getInstance();

    @Override
    public NodeType getNodeTypeEnum() {
        return NodeType.UNKNOWN_NODE;
    }

    @Override
    public short getNodeType() {
        return this.getNodeTypeEnum().getCode();
    }

    @Override
    public String getNodeTypeName() {
        return this.getNodeTypeEnum().getName();
    }

    @Override
    public Document getDocument() {
        Metaset element = this.getParent();
        return element != null ? element.getDocument() : null;
    }

    @Override
    public void setDocument(Document document) {
    }

    @Override
    public Metaset getParent() {
        return null;
    }

    @Override
    public void setParent(Metaset parent) {
    }

    @Override
    public boolean supportsParent() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean hasContent() {
        return false;
    }

    @Override
    public String getPath() {
        return this.getPath(null);
    }

    @Override
    public String getUniquePath() {
        return this.getUniquePath(null);
    }

    @Override
    public AbstractNode clone() {
        if (this.isReadOnly()) {
            return this;
        }
        try {
            AbstractNode answer = (AbstractNode)super.clone();
            answer.setParent(null);
            answer.setDocument(null);
            return answer;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This should never happen. Caught: ", e);
        }
    }

    @Override
    public Node detach() {
        Metaset parent = this.getParent();
        if (parent != null) {
            parent.remove(this);
        } else {
            Document document = this.getDocument();
            if (document != null) {
                document.remove(this);
            }
        }
        this.setParent(null);
        this.setDocument(null);
        return this;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException("This node cannot be modified");
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public String getStringValue() {
        return this.getText();
    }

    @Override
    public void setText(String text) {
        throw new UnsupportedOperationException("This node cannot be modified");
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(this.asXML());
    }

    @Override
    public Object selectObject(String xpathExpression) {
        XPath xpath = this.createXPath(xpathExpression);
        return xpath.evaluate(this);
    }

    @Override
    public List<? extends Node> selectNodes(String xpathExpression) {
        XPath xpath = this.createXPath(xpathExpression);
        return xpath.selectNodes(this);
    }

    @Override
    public List<? extends Node> selectNodes(String xpathExpression, String comparisonXPathExpression) {
        return this.selectNodes(xpathExpression, comparisonXPathExpression, false);
    }

    @Override
    public List<? extends Node> selectNodes(String xpathExpression, String comparisonXPathExpression, boolean removeDuplicates) {
        XPath xpath = this.createXPath(xpathExpression);
        XPath sortBy = this.createXPath(comparisonXPathExpression);
        return xpath.selectNodes(this, sortBy, removeDuplicates);
    }

    @Override
    public Node selectSingleNode(String xpathExpression) {
        XPath xpath = this.createXPath(xpathExpression);
        return xpath.selectSingleNode(this);
    }

    @Override
    public String valueOf(String xpathExpression) {
        XPath xpath = this.createXPath(xpathExpression);
        return xpath.valueOf(this);
    }

    @Override
    public Number numberValueOf(String xpathExpression) {
        XPath xpath = this.createXPath(xpathExpression);
        return xpath.numberValueOf(this);
    }

    @Override
    public boolean matches(String patternText) {
        NodeFilter filter = this.createXPathFilter(patternText);
        return filter.matches(this);
    }

    @Override
    public XPath createXPath(String xpathExpression) {
        return this.getDocumentFactory().createXPath(xpathExpression);
    }

    public NodeFilter createXPathFilter(String patternText) {
        return this.getDocumentFactory().createXPathFilter(patternText);
    }

    public Pattern createPattern(String patternText) {
        return this.getDocumentFactory().createPattern(patternText);
    }

    @Override
    public Node asXPathResult(Metaset parent) {
        if (this.supportsParent()) {
            return this;
        }
        return this.createXPathResult(parent);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    protected void toString(StringBuilder builder) {
        builder.append(super.toString());
    }

    protected DocumentFactory getDocumentFactory() {
        return DOCUMENT_FACTORY;
    }

    protected Node createXPathResult(Metaset parent) {
        throw new RuntimeException("asXPathResult() not yet implemented fully for: " + this);
    }
}

