/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.tree;

import java.util.List;
import org.act.xservices.rt.xom.Attribute;
import org.act.xservices.rt.xom.Branch;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Namespace;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.QName;
import org.act.xservices.rt.xom.tree.AbstractElement;
import org.act.xservices.rt.xom.tree.ContentListFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseElement
extends AbstractElement {
    private QName qname;
    private Branch parentBranch;
    protected List<Node> content;
    protected List<Attribute> attributes;

    public BaseElement(String name) {
        this.qname = this.getDocumentFactory().createQName(name);
    }

    public BaseElement(QName qname) {
        this.qname = qname;
    }

    public BaseElement(String name, Namespace namespace) {
        this.qname = this.getDocumentFactory().createQName(name, namespace);
    }

    @Override
    public Metaset getParent() {
        Metaset result = null;
        if (this.parentBranch instanceof Metaset) {
            result = (Metaset)this.parentBranch;
        }
        return result;
    }

    @Override
    public void setParent(Metaset parent) {
        if (this.parentBranch instanceof Metaset || parent != null) {
            this.parentBranch = parent;
        }
    }

    @Override
    public Document getDocument() {
        if (this.parentBranch instanceof Document) {
            return (Document)this.parentBranch;
        }
        if (this.parentBranch instanceof Metaset) {
            Metaset parent = (Metaset)this.parentBranch;
            return parent.getDocument();
        }
        return null;
    }

    @Override
    public void setDocument(Document document) {
        if (this.parentBranch instanceof Document || document != null) {
            this.parentBranch = document;
        }
    }

    @Override
    public boolean supportsParent() {
        return true;
    }

    @Override
    public QName getQName() {
        return this.qname;
    }

    @Override
    public void setQName(QName name) {
        this.qname = name;
    }

    @Override
    public void clearContent() {
        this.contentList().clear();
    }

    @Override
    public void setContent(List<Node> content) {
        this.content = content;
        if (content instanceof ContentListFacade) {
            this.content = ((ContentListFacade)content).getBackingList();
        }
    }

    @Override
    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
        if (attributes instanceof ContentListFacade) {
            this.attributes = ((ContentListFacade)attributes).getBackingList();
        }
    }

    @Override
    protected List<Node> contentList() {
        if (this.children != null) {
            return this.children;
        }
        if (this.content == null) {
            this.content = this.createContentList();
        }
        return this.content;
    }

    @Override
    protected List<Attribute> attributeList() {
        if (this.attributes == null) {
            this.attributes = this.createAttributeList();
        }
        return this.attributes;
    }

    @Override
    protected List<Attribute> attributeList(int size) {
        if (this.attributes == null) {
            this.attributes = this.createAttributeList(size);
        }
        return this.attributes;
    }

    protected void setAttributeList(List<Attribute> attributeList) {
        this.attributes = attributeList;
    }
}

