/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.tree;

import java.util.Iterator;
import java.util.List;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentFactory;
import org.act.xservices.rt.xom.DocumentType;
import org.act.xservices.rt.xom.IllegalAddException;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.NodeHelper;
import org.act.xservices.rt.xom.ProcessingInstruction;
import org.act.xservices.rt.xom.tree.AbstractDocument;
import org.act.xservices.rt.xom.tree.BackedList;
import org.act.xservices.rt.xom.tree.CloneHelper;
import org.act.xservices.rt.xom.tree.ContentListFacade;
import org.act.xservices.rt.xom.tree.LazyList;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDocument
extends AbstractDocument {
    private String name;
    private Metaset rootElement;
    private final List<Node> content = new LazyList<Node>();
    private DocumentType docType;
    private DocumentFactory documentFactory = DocumentFactory.getInstance();
    private transient EntityResolver entityResolver;

    public DefaultDocument() {
        this(null, null, null);
    }

    public DefaultDocument(String name) {
        this(name, null, null);
    }

    public DefaultDocument(Metaset rootElement) {
        this(null, rootElement, null);
    }

    public DefaultDocument(DocumentType docType) {
        this(null, null, docType);
    }

    public DefaultDocument(Metaset rootElement, DocumentType docType) {
        this(null, rootElement, docType);
    }

    public DefaultDocument(String name, Metaset rootElement, DocumentType docType) {
        this.name = name;
        this.setRootElement(rootElement);
        this.docType = docType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Metaset getRootElement() {
        return this.rootElement;
    }

    @Override
    public DocumentType getDocType() {
        return this.docType;
    }

    @Override
    public void setDocType(DocumentType docType) {
        this.docType = docType;
    }

    @Override
    public Document addDocType(String docTypeName, String publicId, String systemId) {
        this.setDocType(this.getDocumentFactory().createDocType(docTypeName, publicId, systemId));
        return this;
    }

    @Override
    public String getXMLEncoding() {
        return encoding;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public DefaultDocument clone() {
        DefaultDocument document = (DefaultDocument)super.clone();
        document.rootElement = null;
        CloneHelper.setFinalContent(DefaultDocument.class, document);
        document.appendContent(this);
        return document;
    }

    @Override
    public List<ProcessingInstruction> processingInstructions() {
        BackedList<ProcessingInstruction> answer = this.createResultList();
        for (Node node : this.contentList()) {
            ProcessingInstruction pi = NodeHelper.nodeAsProcessingInstruction(node);
            if (pi == null) continue;
            answer.add(pi);
        }
        return answer;
    }

    @Override
    public List<ProcessingInstruction> processingInstructions(String target) {
        BackedList<ProcessingInstruction> answer = this.createResultList();
        for (Node node : this.contentList()) {
            ProcessingInstruction pi = NodeHelper.nodeAsProcessingInstruction(node);
            if (pi == null || !target.equals(pi.getName())) continue;
            answer.add(pi);
        }
        return answer;
    }

    @Override
    public ProcessingInstruction processingInstruction(String target) {
        for (Node node : this.contentList()) {
            ProcessingInstruction pi = NodeHelper.nodeAsProcessingInstruction(node);
            if (pi == null || !target.equals(pi.getName())) continue;
            return pi;
        }
        return null;
    }

    @Override
    public boolean removeProcessingInstruction(String target) {
        Iterator<Node> iter = this.contentList().iterator();
        while (iter.hasNext()) {
            Node node = iter.next();
            ProcessingInstruction pi = NodeHelper.nodeAsProcessingInstruction(node);
            if (pi == null || !target.equals(pi.getName())) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public void setContent(List<Node> content) {
        this.rootElement = null;
        this.contentRemoved();
        if (content instanceof ContentListFacade) {
            content = ((ContentListFacade)content).getBackingList();
        }
        this.contentList().clear();
        if (content == null) {
            return;
        }
        List<Node> newContent = this.createContentList();
        for (Node node : content) {
            Metaset element;
            Document doc = node.getDocument();
            if (doc != null && doc != this) {
                node = (Node)node.clone();
            }
            if ((element = NodeHelper.nodeAsElement(node)) != null) {
                if (this.rootElement == null) {
                    this.rootElement = element;
                } else {
                    throw new IllegalAddException("A document may only contain one root element: " + content);
                }
            }
            newContent.add(node);
            this.childAdded(node);
        }
        this.contentList().addAll(newContent);
    }

    @Override
    public void clearContent() {
        this.contentRemoved();
        this.contentList().clear();
        this.rootElement = null;
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    @Override
    protected List<Node> contentList() {
        assert (this.content != null);
        return this.content;
    }

    @Override
    protected void addNode(Node node) {
        if (node != null) {
            Document document = node.getDocument();
            if (document != null && document != this) {
                String message = "The Node already has an existing document: " + document;
                throw new IllegalAddException(this, node, message);
            }
            this.contentList().add(node);
            this.childAdded(node);
        }
    }

    @Override
    protected void addNode(int index, Node node) {
        if (node != null) {
            Document document = node.getDocument();
            if (document != null && document != this) {
                String message = "The Node already has an existing document: " + document;
                throw new IllegalAddException(this, node, message);
            }
            this.contentList().add(index, node);
            this.childAdded(node);
        }
    }

    @Override
    protected boolean removeNode(Node node) {
        if (node == this.rootElement) {
            this.rootElement = null;
        }
        if (this.contentList().remove(node)) {
            this.childRemoved(node);
            return true;
        }
        return false;
    }

    @Override
    protected void rootElementAdded(Metaset element) {
        this.rootElement = element;
        element.setDocument(this);
    }

    @Override
    protected DocumentFactory getDocumentFactory() {
        return this.documentFactory;
    }
}

