/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.tree;

import java.io.ByteArrayOutputStream;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentFactory;
import org.act.xservices.rt.xom.DocumentHelper;
import org.act.xservices.rt.xom.IllegalAddException;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.io.OutputFormat;
import org.act.xservices.rt.xom.io.XMLWriter;
import org.act.xservices.rt.xom.tree.DefaultDocument;

public class DefaultDocumentTest
extends AbstractTestCase {
    public static void main(String[] args) {
        TestRunner.run(DefaultDocumentTest.class);
    }

    public void testDoubleRootElement() {
        Document document = DocumentFactory.getInstance().createDocument();
        document.addElement("root");
        Metaset root = DocumentFactory.getInstance().createElement("anotherRoot");
        try {
            document.add(root);
            DefaultDocumentTest.fail();
        }
        catch (IllegalAddException e) {
            String msg = e.getMessage();
            DefaultDocumentTest.assertTrue((msg.indexOf(root.toString()) != -1 ? 1 : 0) != 0);
        }
    }

    public void testBug799656() throws Exception {
        Document document = DocumentFactory.getInstance().createDocument();
        Metaset el = document.addElement("root");
        el.setText("text with an \u00fc in it");
        System.out.println(document.asXML());
        DocumentHelper.parseText(document.asXML());
    }

    public void testAsXMLWithEncoding() throws Exception {
        DefaultDocument document = new DefaultDocument();
        document.addElement("root");
        document.setXMLEncoding("ISO-8859-1");
        Document doc = DocumentHelper.parseText("<?xml version='1.0' encoding='ISO-8859-1'?><root/>");
        String xml1 = document.asXML();
        String xml2 = doc.asXML();
        DefaultDocumentTest.assertTrue((xml1.indexOf("ISO-8859-1") != -1 ? 1 : 0) != 0);
        DefaultDocumentTest.assertTrue((xml2.indexOf("ISO-8859-1") != -1 ? 1 : 0) != 0);
    }

    public void testBug1156909() throws Exception {
        Document doc = DocumentHelper.parseText("<?xml version='1.0' encoding='ISO-8859-1'?><root/>");
        DefaultDocumentTest.assertEquals((String)"XMLEncoding not correct", (String)"ISO-8859-1", (String)doc.getXMLEncoding());
    }

    public void testAsXMLWithEncodingAndContent() throws Exception {
        DefaultDocument document = new DefaultDocument();
        document.setXMLEncoding("UTF-16");
        Metaset root = document.addElement("root");
        root.setText("text with an \u00fc in it");
        String xml = document.asXML();
        DefaultDocumentTest.assertTrue((xml.indexOf("UTF-16") != -1 ? 1 : 0) != 0);
        DefaultDocumentTest.assertTrue((xml.indexOf(252) != -1 ? 1 : 0) != 0);
    }

    public void testEncoding() throws Exception {
        Document document = DocumentFactory.getInstance().createDocument("koi8-r");
        Metaset el = document.addElement("root");
        el.setText("text with an \u00fc in it");
        System.out.println(document.asXML());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputFormat of = OutputFormat.createPrettyPrint();
        of.setEncoding("koi8-r");
        XMLWriter writer = new XMLWriter(out, of);
        writer.write(document);
        String result = out.toString("koi8-r");
        System.out.println(result);
        Document doc2 = DocumentHelper.parseText(result);
    }
}

