/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.tree;

import java.util.List;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentFactory;
import org.act.xservices.rt.xom.DocumentHelper;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Namespace;
import org.act.xservices.rt.xom.Node;

public class DefaultElementTest
extends AbstractTestCase {
    public static void main(String[] args) {
        TestRunner.run(DefaultElementTest.class);
    }

    public void testParentAfterSetContent() throws Exception {
        Document doc = DocumentHelper.parseText("<root><a>a</a><b>b</b><x>x</x><d>d</d></root>");
        Node x = doc.selectSingleNode("/root/x");
        List<Node> content = doc.getRootElement().content();
        int position = content.indexOf(x);
        Metaset c = DocumentHelper.createElement("c");
        c.setText("c");
        content.add(position, c);
        DefaultElementTest.assertNotNull((Object)c.getParent());
        doc.getRootElement().setContent(content);
        DefaultElementTest.assertNotNull((String)"Parent is null of setting content", (Object)c.getParent());
    }

    public void testGetStringValue() throws Exception {
        Document doc = this.getDocument("xml/test/test_text.xml");
        Metaset message = doc.getRootElement();
        String text = message.getStringValue();
        DefaultElementTest.assertEquals((String)"String value incorrect", (String)"This should work", (String)text.trim());
        String xpathText = (String)doc.selectObject("normalize-space(/message)");
        DefaultElementTest.assertEquals((String)"xpath value incorrect", (String)"This should work", (String)xpathText);
    }

    public void testBug894878() {
        Metaset foo = DocumentFactory.getInstance().createElement("foo");
        foo.addText("bla").addAttribute("foo", "bar");
        DefaultElementTest.assertEquals((String)"<foo foo=\"bar\">bla</foo>", (String)foo.asXML());
        foo = DocumentFactory.getInstance().createElement("foo");
        foo.addAttribute("foo", "bar").addText("bla");
        DefaultElementTest.assertEquals((String)"<foo foo=\"bar\">bla</foo>", (String)foo.asXML());
    }

    public void testGetNamespacesForURI() throws Exception {
        String xml = "<schema targetNamespace='http://SharedTest.org/xsd'         xmlns='http://www.w3.org/2001/XMLSchema'         xmlns:xsd='http://www.w3.org/2001/XMLSchema'>    <complexType name='AllStruct'>        <all>            <element name='arString' type='xsd:string'/>            <element name='varInt' type='xsd:int'/>        </all>    </complexType></schema>";
        Document doc = DocumentHelper.parseText(xml);
        Metaset schema = doc.getRootElement();
        List<Namespace> namespaces = schema.getNamespacesForURI("http://www.w3.org/2001/XMLSchema");
        DefaultElementTest.assertNotNull(namespaces);
        DefaultElementTest.assertEquals((int)2, (int)namespaces.size());
    }

    public void testDeclaredNamespaces() throws Exception {
        String xml = "<a xmlns:ns1=\"uri1\">    <ns1:b/>    <ns2:c xmlns:ns2=\"uri2\"/></a>";
        Document doc = DocumentHelper.parseText(xml);
        Metaset a = doc.getRootElement();
        List<Namespace> ns = a.declaredNamespaces();
        DefaultElementTest.assertEquals((int)1, (int)ns.size());
        DefaultElementTest.assertSame((Object)a.getNamespaceForPrefix("ns1"), (Object)ns.get(0));
        Metaset b = a.element("b");
        ns = b.declaredNamespaces();
        DefaultElementTest.assertEquals((int)0, (int)ns.size());
        Metaset c = a.element("c");
        ns = c.declaredNamespaces();
        DefaultElementTest.assertEquals((int)1, (int)ns.size());
        DefaultElementTest.assertSame((Object)c.getNamespaceForPrefix("ns2"), (Object)ns.get(0));
    }

    public void testAdditionalNamespaces() throws Exception {
        String xml = "<a xmlns:ns1=\"uri1\">    <ns1:b/>    <ns2:c xmlns:ns2=\"uri2\"/></a>";
        Document doc = DocumentHelper.parseText(xml);
        Metaset a = doc.getRootElement();
        List<Namespace> ns = a.additionalNamespaces();
        DefaultElementTest.assertEquals((int)1, (int)ns.size());
        DefaultElementTest.assertSame((Object)a.getNamespaceForPrefix("ns1"), (Object)ns.get(0));
        Metaset b = a.element("b");
        ns = b.additionalNamespaces();
        DefaultElementTest.assertEquals((int)0, (int)ns.size());
        Metaset c = a.element("c");
        ns = c.additionalNamespaces();
        DefaultElementTest.assertEquals((int)0, (int)ns.size());
    }
}

