/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.act.xservices.rt.xom.tree.CloneHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyList<E>
extends AbstractSequentialList<E>
implements Serializable {
    private static final long serialVersionUID = 0L;
    protected transient E[] indexedList = null;
    protected final transient Entry<E> header;
    protected transient int size = 0;

    public LazyList() {
        this.header = new Entry<Object>(null, null, null);
        this.header.next = this.header;
        this.header.previous = this.header;
    }

    protected LazyList(Entry<E> header) {
        this.header = header;
    }

    @Override
    public boolean add(E element) {
        this.addElement(element, this.header);
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.addElement(element, index == this.size ? this.header : this.getEntry(index));
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.addAll(0, collection);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        Entry entry = this.getEntryHeader((int)index).next;
        for (E element : collection) {
            this.addElement(element, entry);
        }
        return true;
    }

    @Override
    public void clear() {
        this.indexedList = null;
        this.size = 0;
        this.header.element = null;
        this.header.next = this.header;
        this.header.previous = this.header;
        ++this.modCount;
    }

    @Override
    public E get(int index) {
        this.createIndexedList();
        return this.indexedList[index];
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new LazyListIterator(index);
    }

    @Override
    public E remove(int index) {
        return this.removeEntry(this.getEntry(index));
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        Range<E> range = this.getRange(fromIndex, toIndex);
        range.lower.previous.next = range.upper;
        range.upper.previous = range.lower.previous;
    }

    @Override
    public E set(int index, E element) {
        Entry<E> entry = this.getEntry(index);
        Object oldValue = entry.element;
        entry.element = element;
        if (this.indexedList != null) {
            this.indexedList[index] = element;
        }
        return oldValue;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        Entry<Object> newHeader;
        Range<E> range = this.getRange(fromIndex, toIndex);
        Entry<Object> lastEntry = newHeader = new Entry<Object>(null, range.lower, range.upper);
        while (range.lower != range.upper) {
            lastEntry.next = new Entry<Object>(range.lower.element, null, lastEntry);
            lastEntry = lastEntry.next;
            range.lower = range.lower.next;
        }
        newHeader.previous = lastEntry;
        return new LazyList<Object>(newHeader);
    }

    @Override
    public int size() {
        return this.size;
    }

    public LazyList<E> clone() {
        LazyList clone = new LazyList();
        Entry entry = this.header.next;
        while (entry != this.header) {
            clone.add(entry.element);
            entry = entry.next;
        }
        return clone;
    }

    protected void createIndexedList() {
        if (this.indexedList == null) {
            this.indexedList = new Object[this.size];
            int index = 0;
            for (Object element : this) {
                this.indexedList[index++] = element;
            }
        }
    }

    protected Entry<E> addElement(E e, Entry<E> entry) {
        this.indexedList = null;
        Entry<E> newEntry = new Entry<E>(e, entry, entry.previous);
        newEntry.previous.next = newEntry;
        newEntry.next.previous = newEntry;
        ++this.size;
        ++this.modCount;
        return newEntry;
    }

    protected Entry<E> getEntry(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(MessageFormat.format("Index: {0}, Size: {1}", index, this.size));
        }
        if (index == 0) {
            return this.header.next;
        }
        Entry<E> e = this.header;
        if (index < this.size >> 1) {
            int i = 0;
            while (i <= index) {
                e = e.next;
                ++i;
            }
        } else {
            int i = this.size;
            while (i > index) {
                e = e.previous;
                --i;
            }
        }
        return e;
    }

    protected Entry<E> getEntryHeader(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException(MessageFormat.format("Index: {0}, Size: {1}", index, this.size));
        }
        if (index == 0) {
            return this.header.next;
        }
        Entry<E> e = this.header;
        if (index < this.size >> 1) {
            int i = 0;
            while (i < index) {
                e = e.next;
                ++i;
            }
        } else {
            int i = this.size;
            while (i > index) {
                e = e.previous;
                --i;
            }
        }
        return e;
    }

    private Range<E> getRange(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException(MessageFormat.format("FromIndex: {0}, ToIndex: {1}, Size: {2}", fromIndex, toIndex, this.size));
        }
        int[] length = new int[]{fromIndex, toIndex - fromIndex, this.size - toIndex};
        Range range = new Range();
        if (length[0] < length[2]) {
            range.lower = this.header;
            int i = 0;
            while (i <= fromIndex) {
                range.lower = range.lower.next;
                ++i;
            }
            if (length[1] < length[2]) {
                range.upper = range.lower;
                i = fromIndex;
                while (i <= toIndex) {
                    range.upper = range.upper.next;
                    ++i;
                }
            } else {
                range.upper = this.header;
                i = this.size;
                while (i > toIndex) {
                    range.upper = range.upper.previous;
                    --i;
                }
            }
        } else {
            range.upper = this.header;
            int i = this.size;
            while (i > toIndex) {
                range.upper = range.upper.previous;
                --i;
            }
            if (length[0] < length[1]) {
                range.lower = this.header;
                i = 0;
                while (i <= fromIndex) {
                    range.lower = range.lower.next;
                    ++i;
                }
            } else {
                range.lower = range.upper;
                i = toIndex;
                while (i > fromIndex) {
                    range.lower = range.lower.previous;
                    --i;
                }
            }
        }
        return range;
    }

    protected E removeEntry(Entry<E> entry) {
        if (entry == this.header) {
            throw new NoSuchElementException();
        }
        this.indexedList = null;
        entry.previous.next = entry.next;
        entry.next.previous = entry.previous;
        --this.size;
        ++this.modCount;
        return entry.element;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.size);
        Entry entry = this.header.next;
        while (entry != this.header) {
            stream.writeObject(entry.element);
            entry = entry.next;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        CloneHelper.setFinalField(LazyList.class, this, "header", new Entry<Object>(null, null, null));
        assert (this.header != null);
        this.header.previous = this.header;
        this.header.next = this.header.previous;
        int size = stream.readInt();
        Object[] tempIndexedList = new Object[size];
        int i = 0;
        while (i < size) {
            Object element = stream.readObject();
            this.addElement(element, this.header);
            tempIndexedList[i] = element;
            ++i;
        }
        this.indexedList = tempIndexedList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Entry<E> {
        E element;
        Entry<E> next;
        Entry<E> previous;

        Entry(E element, Entry<E> next, Entry<E> previous) {
            this.element = element;
            this.next = next;
            this.previous = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LazyListIterator
    implements ListIterator<E> {
        private Entry<E> lastReturned;
        private Entry<E> next;
        private int indexNext;
        private int expectedModCount;

        LazyListIterator(int index) {
            this.lastReturned = LazyList.this.header;
            this.expectedModCount = LazyList.this.modCount;
            this.next = LazyList.this.getEntryHeader(index);
        }

        @Override
        public boolean hasNext() {
            return this.indexNext != LazyList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            if (this.indexNext == LazyList.this.size) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.indexNext;
            return this.lastReturned.element;
        }

        @Override
        public boolean hasPrevious() {
            return this.indexNext != 0;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            if (this.indexNext == 0) {
                throw new NoSuchElementException();
            }
            this.next = this.next.previous;
            this.lastReturned = this.next;
            --this.indexNext;
            return this.lastReturned.element;
        }

        @Override
        public int nextIndex() {
            return this.indexNext;
        }

        @Override
        public int previousIndex() {
            return this.indexNext - 1;
        }

        @Override
        public void remove() {
            this.checkForOutside();
            this.checkForComodification();
            Entry lastNext = this.lastReturned.next;
            LazyList.this.removeEntry(this.lastReturned);
            if (this.next == this.lastReturned) {
                this.next = lastNext;
            } else {
                --this.indexNext;
            }
            this.lastReturned = LazyList.this.header;
            ++this.expectedModCount;
        }

        @Override
        public void set(E e) {
            this.checkForOutside();
            this.checkForComodification();
            this.lastReturned.element = e;
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            this.lastReturned = LazyList.this.header;
            LazyList.this.addElement(e, this.next);
            ++this.indexNext;
            ++this.expectedModCount;
        }

        final void checkForComodification() {
            if (LazyList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForOutside() {
            if (this.lastReturned == LazyList.this.header) {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Range<E> {
        Entry<E> lower;
        Entry<E> upper;

        private Range() {
        }
    }
}

