/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.tree;

import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Namespace;
import org.act.xservices.rt.xom.tree.NamespaceCache;

public class NamespaceCacheTest
extends AbstractTestCase {
    private static final int THREADCOUNT = 50;
    private static final int ITERATIONCOUNT = 10000;

    public static void main(String[] args) {
        TestRunner.run(NamespaceCacheTest.class);
    }

    public void testGetSameNamespaceSingleThread() {
        long start = System.currentTimeMillis();
        SameNSTest test = new SameNSTest();
        test.run();
        long end = System.currentTimeMillis();
        System.out.println("Same NS Single took " + (end - start) + " ms");
    }

    public void testGetSameNamespaceMultiThread() throws Exception {
        long start = System.currentTimeMillis();
        this.runMultiThreadedTest(new SameNSTest());
        long end = System.currentTimeMillis();
        System.out.println("Different NS Single took " + (end - start) + " ms");
    }

    public void testGetNewNamespaceSingleThread() {
        long start = System.currentTimeMillis();
        DifferentNSTest test = new DifferentNSTest();
        test.run();
        long end = System.currentTimeMillis();
        System.out.println("Same NS Multi took " + (end - start) + " ms");
    }

    public void testGetNewNamespaceMultiThread() throws Exception {
        long start = System.currentTimeMillis();
        this.runMultiThreadedTest(new DifferentNSTest());
        long end = System.currentTimeMillis();
        System.out.println("Different NS Multi took " + (end - start) + " ms");
    }

    private void runMultiThreadedTest(Runnable test) throws Exception {
        Thread[] threads = new Thread[50];
        int i = 0;
        while (i < 50) {
            threads[i] = new Thread(new SameNSTest());
            ++i;
        }
        int j = 0;
        while (j < 50) {
            threads[j].start();
            ++j;
        }
        int k = 0;
        while (k < 50) {
            threads[k].join();
            ++k;
        }
    }

    private class DifferentNSTest
    implements Runnable {
        private DifferentNSTest() {
        }

        public void run() {
            NamespaceCache cache = new NamespaceCache();
            int i = 0;
            while (i < 10000) {
                Namespace namespace = cache.get("prefix", Integer.toString(i));
                ++i;
            }
        }
    }

    private class SameNSTest
    implements Runnable {
        private SameNSTest() {
        }

        public void run() {
            NamespaceCache cache = new NamespaceCache();
            int i = 0;
            while (i < 10000) {
                Namespace namespace = cache.get("prefix", "uri");
                ++i;
            }
        }
    }
}

