/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.util;

import java.util.List;
import org.act.xservices.rt.xom.Attribute;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.NodeHelper;
import org.act.xservices.rt.xom.QName;
import org.act.xservices.rt.xom.tree.BackedList;
import org.act.xservices.rt.xom.tree.DefaultElement;
import org.act.xservices.rt.xom.tree.LazyList;
import org.act.xservices.rt.xom.util.DoubleNameMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedElement
extends DefaultElement {
    private DoubleNameMap<List<Metaset>> elementIndex;
    private DoubleNameMap<Attribute> attributeIndex;

    public IndexedElement(String name) {
        super(name);
    }

    public IndexedElement(QName qname) {
        super(qname);
    }

    public IndexedElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    @Override
    public Attribute attribute(String name) {
        return this.attributeIndex().get(name);
    }

    @Override
    public Attribute attribute(QName qName) {
        return this.attributeIndex().get(qName);
    }

    @Override
    public Metaset element(String name) {
        return IndexedElement.firstElement(this.elementIndex().get(name));
    }

    @Override
    public Metaset element(QName qName) {
        return IndexedElement.firstElement(this.elementIndex().get(qName));
    }

    @Override
    public List<Metaset> elements(String name) {
        return this.asElementList(this.elementIndex().get(name));
    }

    @Override
    public List<Metaset> elements(QName qName) {
        return this.asElementList(this.elementIndex().get(qName));
    }

    protected static Metaset firstElement(List<Metaset> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    protected List<Metaset> asElementList(List<Metaset> list) {
        BackedList<Metaset> answer = this.createResultList();
        for (Metaset element : list) {
            answer.addLocal(element);
        }
        return answer;
    }

    @Override
    protected void addNode(Node node) {
        super.addNode(node);
        switch (node.getNodeTypeEnum()) {
            case ELEMENT_NODE: {
                if (this.elementIndex == null) break;
                this.addToElementIndex((Metaset)node);
                break;
            }
            case ATTRIBUTE_NODE: {
                if (this.attributeIndex == null) break;
                this.addToAttributeIndex((Attribute)node);
            }
        }
    }

    @Override
    protected boolean removeNode(Node node) {
        if (super.removeNode(node)) {
            switch (node.getNodeTypeEnum()) {
                case ELEMENT_NODE: {
                    if (this.elementIndex == null) break;
                    this.removeFromElementIndex((Metaset)node);
                    break;
                }
                case ATTRIBUTE_NODE: {
                    if (this.attributeIndex == null) break;
                    this.removeFromAttributeIndex((Attribute)node);
                }
            }
            return true;
        }
        return false;
    }

    protected DoubleNameMap<Attribute> attributeIndex() {
        if (this.attributeIndex == null) {
            this.attributeIndex = new DoubleNameMap();
            for (Attribute attribute : this.attributeList()) {
                this.addToAttributeIndex(attribute);
            }
        }
        return this.attributeIndex;
    }

    protected DoubleNameMap<List<Metaset>> elementIndex() {
        if (this.elementIndex == null) {
            this.elementIndex = new DoubleNameMap();
            for (Node node : this.contentList()) {
                Metaset element = NodeHelper.nodeAsElement(node);
                if (element == null) continue;
                this.addToElementIndex(element);
            }
        }
        return this.elementIndex;
    }

    protected void addToElementIndex(Metaset element) {
        QName qName = element.getQName();
        List<Metaset> list = this.elementIndex.get(qName);
        if (list == null) {
            list = new LazyList<Metaset>();
            this.elementIndex.put(qName, list);
        }
        list.add(element);
    }

    protected void removeFromElementIndex(Metaset element) {
        QName qName = element.getQName();
        List<Metaset> list = this.elementIndex.get(qName);
        if (list != null) {
            list.remove(element);
            if (list.isEmpty()) {
                this.elementIndex.remove(qName);
            }
        }
    }

    protected void addToAttributeIndex(Attribute attribute) {
        QName qName = attribute.getQName();
        this.attributeIndex.put(qName, attribute);
    }

    protected void removeFromAttributeIndex(Attribute attribute) {
        QName qName = attribute.getQName();
        this.attributeIndex.remove(qName);
    }
}

