/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.util;

import com.clarkware.junitperf.LoadTest;
import com.clarkware.junitperf.TimedTest;
import java.util.HashMap;
import java.util.Map;
import junit.extensions.RepeatedTest;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.act.xservices.rt.xom.util.PerThreadSingleton;
import org.act.xservices.rt.xom.util.SingletonStrategy;

public class PerThreadSingletonTest
extends TestCase {
    private static SingletonStrategy singleton;
    private static ThreadLocal reference;

    static {
        reference = new ThreadLocal();
    }

    public PerThreadSingletonTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        super.setUp();
        Class<PerThreadSingletonTest> clazz = PerThreadSingletonTest.class;
        synchronized (PerThreadSingletonTest.class) {
            if (singleton == null) {
                singleton = new PerThreadSingleton();
                singleton.setSingletonClassName(HashMap.class.getName());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testInstance() throws Exception {
        String tid = Thread.currentThread().getName();
        Map map = (Map)singleton.instance();
        String expected = "new value";
        if (!map.containsKey(tid) && reference.get() != null) {
            System.out.println("tid=" + tid + " map=" + map);
            System.out.println("reference=" + reference);
            System.out.println("singleton=" + singleton);
            PerThreadSingletonTest.fail((String)"created singleton more than once");
        } else {
            map.put(tid, expected);
            reference.set(map);
        }
        String actual = (String)map.get(tid);
        PerThreadSingletonTest.assertEquals((String)"testInstance", (String)expected, (String)actual);
        map = (Map)singleton.instance();
        expected = "new value";
        actual = (String)map.get(tid);
        PerThreadSingletonTest.assertEquals((String)"testInstance", (String)expected, (String)actual);
        PerThreadSingletonTest.assertEquals((String)"testInstance reference", reference.get(), (Object)map);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(PerThreadSingletonTest.makeRepeatedLoadTest(5, 100, "testInstance"));
        return suite;
    }

    protected static Test makeRepeatedLoadTest(int users, int iterations, String testMethod) {
        long maxElapsedTime = 1200 + 1000 * users * iterations;
        PerThreadSingletonTest testCase = new PerThreadSingletonTest(testMethod);
        RepeatedTest repeatedTest = new RepeatedTest((Test)testCase, iterations);
        LoadTest loadTest = new LoadTest((Test)repeatedTest, users);
        TimedTest timedTest = new TimedTest((Test)loadTest, maxElapsedTime);
        return timedTest;
    }
}

