/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.util;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.act.xservices.rt.xom.util.PerThreadSingleton;
import org.act.xservices.rt.xom.util.SingletonStrategy;

public class SimpleSingletonTest
extends TestCase {
    private static SingletonStrategy singleton;
    private static Object reference;

    public SimpleSingletonTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        if (singleton == null) {
            singleton = new PerThreadSingleton();
            singleton.setSingletonClassName(HashMap.class.getName());
        }
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testFirstInstance() throws Exception {
        Map map = (Map)singleton.instance();
        String expected = null;
        String actual = (String)map.get("Test");
        SimpleSingletonTest.assertEquals((String)"testInstance", expected, (String)actual);
        expected = "new value";
        map.put("Test", expected);
        map = (Map)singleton.instance();
        reference = map;
        actual = (String)map.get("Test");
        SimpleSingletonTest.assertEquals((String)"testFirstInstance", (String)expected, (String)actual);
    }

    public void testSecondInstance() throws Exception {
        Map map = (Map)singleton.instance();
        SimpleSingletonTest.assertEquals((String)"testSecondInstance reference", (Object)reference, (Object)map);
        String actual = (String)map.get("Test");
        String expected = "new value";
        SimpleSingletonTest.assertEquals((String)"testInstance", (String)expected, (String)actual);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(TestSuite.createTest(SimpleSingletonTest.class, (String)"testFirstInstance"));
        suite.addTest(TestSuite.createTest(SimpleSingletonTest.class, (String)"testSecondInstance"));
        return suite;
    }
}

