/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.xpath;

import java.util.List;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Attribute;
import org.act.xservices.rt.xom.DocumentHelper;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.XPath;

public class AttributeTest
extends AbstractTestCase {
    protected static String[] paths = new String[]{"attribute::*", "/root/author/attribute::*", "//attribute::*", "@name"};

    public static void main(String[] args) {
        TestRunner.run(AttributeTest.class);
    }

    public void testXPaths() throws Exception {
        int size = paths.length;
        int i = 0;
        while (i < size) {
            this.testXPath(paths[i]);
            ++i;
        }
    }

    protected void testXPath(String xpathText) {
        XPath xpath = DocumentHelper.createXPath(xpathText);
        List<? extends Node> list = xpath.selectNodes(this.document);
        this.log("Searched path: " + xpathText + " found: " + list.size() + " result(s)");
        for (Node node : list) {
            this.log("Found Result: " + node);
            AttributeTest.assertTrue((String)"Results should be Attribute objects", (boolean)(node instanceof Attribute));
            Attribute attribute = (Attribute)node;
            AttributeTest.assertTrue((String)"Results should support the parent relationship", (boolean)attribute.supportsParent());
            AttributeTest.assertTrue((String)"Results should contain reference to the parent element", (attribute.getParent() != null ? 1 : 0) != 0);
            AttributeTest.assertTrue((String)"Resulting document not correct", (attribute.getDocument() != null ? 1 : 0) != 0);
        }
    }
}

