/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.xpath;

import java.util.List;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.DocumentHelper;
import org.act.xservices.rt.xom.Namespace;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.XPath;
import org.act.xservices.rt.xom.io.SAXReader;

public class NamespaceTest
extends AbstractTestCase {
    protected static String[] paths = new String[]{"namespace::*", "/Template/Application1/namespace::*", "/Template/Application1/namespace::xplt", "//namespace::*"};

    public static void main(String[] args) {
        TestRunner.run(NamespaceTest.class);
    }

    public void testXPaths() throws Exception {
        int size = paths.length;
        int i = 0;
        while (i < size) {
            this.testXPath(paths[i]);
            ++i;
        }
    }

    protected void testXPath(String xpathText) {
        XPath xpath = DocumentHelper.createXPath(xpathText);
        List<? extends Node> list = xpath.selectNodes(this.document);
        this.log("Searched path: " + xpathText + " found: " + list.size() + " result(s)");
        for (Node node : list) {
            this.log("Found Result: " + node);
            NamespaceTest.assertTrue((String)"Results should be Namespace objects", (boolean)(node instanceof Namespace));
            Namespace namespace = (Namespace)node;
            this.log("Parent node: " + namespace.getParent());
            NamespaceTest.assertTrue((String)"Results should support the parent relationship", (boolean)namespace.supportsParent());
            NamespaceTest.assertTrue((String)"Results should contain reference to the parent element", (namespace.getParent() != null ? 1 : 0) != 0);
            NamespaceTest.assertTrue((String)"Results should contain reference to the document", (namespace.getDocument() != null ? 1 : 0) != 0);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.document = new SAXReader().read(this.getFile("xml/testNamespaces.xml"));
    }
}

