/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.xpath;

import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.XPath;

public class NumberTest
extends AbstractTestCase {
    protected static String[] paths = new String[]{"2+2", "2 + 2", "2 + number(1) + 2", "number(1) * 2", "2 + count(//author) + 2", "2 + (2 * 5)", "count(//author) + count(//author/attribute::*)", "(12 + count(//author) + count(//author/attribute::*)) div 2", "count(//author)", "count(//author/attribute::*)", "2 + number(1) * 2", "count(descendant::author)", "count(ancestor::author)", "count(descendant::*)", "count(descendant::author)+1", "count(ancestor::*)", "10 + count(ancestor-or-self::author) + 5", "10 + count(descendant::author) * 5", "10 + (count(descendant::author) * 5)"};

    public static void main(String[] args) {
        TestRunner.run(NumberTest.class);
    }

    public void testXPaths() throws Exception {
        Node element = this.document.selectSingleNode("//author");
        int size = paths.length;
        int i = 0;
        while (i < size) {
            this.testXPath(this.document, paths[i]);
            this.testXPath(element, paths[i]);
            ++i;
        }
        this.log("Finished successfully");
    }

    protected void testXPath(Node node, String xpathText) throws Exception {
        try {
            XPath xpath = node.createXPath(xpathText);
            Number number = xpath.numberValueOf(node);
            this.log("Searched path: " + xpathText + " found: " + number);
        }
        catch (Throwable e) {
            this.log("Caught exception: " + e);
            e.printStackTrace();
            NumberTest.assertTrue((String)("Failed to process:  " + xpathText + " caught exception: " + e), (boolean)false);
        }
    }
}

